<?php

require('Medoo.php');

include '/var/www/html/admin/assets/layouts/header.php';

use \Medoo\Medoo;

function date_compare($element1, $element2) {
  $datetime1 = strtotime($element1['date_added']);
  $datetime2 = strtotime($element2['date_added']);
  return $datetime2 - $datetime1;
} 

if(check_logged_in()) {

$orgId = $_SESSION['organisation_id'];
} else {
  exit();
}

$database = new \Medoo\Medoo([
	// [required]
  'type' => 'mysql',
	'host' => 'localhost',
	'database' => 'gpsTest',
	'username' => 'gpsTest',
	'password' => '6HNV*=?U',

	// [optional]
	'charset' => 'utf8mb4',
	'collation' => 'utf8mb4_general_ci',
	'port' => 3306,

	// [optional] The table prefix. All table names will be prefixed as PREFIX_table.
//	'prefix' => 'PREFIX_',

	// [optional] To enable logging. It is disabled by default for better performance.
	//'logging' => true,

	// [optional]
	// Error mode
	// Error handling strategies when the error has occurred.
	// PDO::ERRMODE_SILENT (default) | PDO::ERRMODE_WARNING | PDO::ERRMODE_EXCEPTION
	// Read more from https://www.php.net/manual/en/pdo.error-handling.php.
	'error' => PDO::ERRMODE_EXCEPTION,

	// [optional]
	// The driver_option for connection.
	// Read more from http://www.php.net/manual/en/pdo.setattribute.php.

  'option' => [
		PDO::ATTR_CASE => PDO::CASE_NATURAL
	],

	// [optional] Medoo will execute those commands after the database is connected.
  /*
  'command' => [
		'SET SQL_MODE=ANSI_QUOTES'
	]
  */
]);

$changelogs = $database->query("SELECT * FROM `changelog` ORDER BY `changelog`.`date_added` DESC")->fetchAll();

if (count($changelogs) > 0) {

} else {
    array_push($changelogs, array("title" => "Das System ChangeLog !",
    "description" => "Hier werden in Zukunft alle Neuigkeiten chronologisch für Sie veröffentlicht!",
    "date_added" => "AB JETZT"));
}

?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title>Table - Brand</title>
    <link rel="stylesheet" href="bs_assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i&amp;display=swap">
    <link rel="stylesheet" href="bs_assets/fonts/fontawesome-all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <link rel="stylesheet" href="assets/js/formvalidation/css/formValidation.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://unpkg.com/tachyons@4.10.0/css/tachyons.min.css">
    <style>
      .fv-plugins-icon {
        margin-top: -10px !important;
      }
    </style>
</head>

<body id="page-top">
    <div id="wrapper">
        <nav class="navbar navbar-dark align-items-start sidebar sidebar-dark accordion bg-gradient-primary p-0">
            <div class="container-fluid d-flex flex-column p-0"><a class="navbar-brand d-flex justify-content-center align-items-center sidebar-brand m-0" href="#">
                    <div class="sidebar-brand-icon rotate-n-15"></div>
                    <div class="sidebar-brand-text mx-3"><span>SOLUTION4CARE</span></div>
                </a>
                <hr class="sidebar-divider my-0">
                <ul class="navbar-nav text-light" id="accordionSidebar">
                  <li class="nav-item"><a class="nav-link" href="customerOverview.php"><i class="fas fa-tachometer-alt"></i><span>Gerätestatus</span></a></li>
                  <li class="nav-item"><a class="nav-link" href="zuweisung.php"><i class="fas fa-plus-circle"></i><span>Geräte programmieren</span></a></li>
                  <li class="nav-item"></li>
                </ul>
                <div class="text-center d-none d-md-inline"><button class="btn rounded-circle border-0" id="sidebarToggle" type="button"></button></div>
            </div>
            <a href="changelog.php" style="position:absolute;margin-top:600px;width:100%;text-align:center;color:white;text-decoration:none;font-size:0.7em;">CHANGELOG</a>
        </nav>
        <div class="d-flex flex-column" id="content-wrapper">
            <div id="content" style="width: 100%;">
                <nav class="navbar navbar-light navbar-expand bg-white shadow mb-4 topbar static-top">
                    <div class="container-fluid"><button class="btn btn-link d-md-none rounded-circle me-3" id="sidebarToggleTop" type="button"><i class="fas fa-bars"></i></button><span class="fw-bold d-none d-lg-inline me-2 text-gray-600 small">CUSTOMER CONSOLE</span>
                        <ul class="navbar-nav flex-nowrap ms-auto">
                            <li class="nav-item dropdown d-sm-none no-arrow"><a class="dropdown-toggle nav-link" aria-expanded="false" data-bs-toggle="dropdown" href="#"><i class="fas fa-search"></i></a>
                                <div class="dropdown-menu dropdown-menu-end p-3 animated--grow-in" aria-labelledby="searchDropdown">
                                    <form class="me-auto navbar-search w-100">
                                        <div class="input-group"><input class="bg-light form-control border-0 small" type="text" placeholder="Search for ...">
                                            <div class="input-group-append"><button class="btn btn-primary py-0" type="button"><i class="fas fa-search"></i></button></div>
                                        </div>
                                    </form>
                                </div>
                            </li>
                            <li class="nav-item dropdown no-arrow mx-1"></li>
                            <li class="nav-item dropdown no-arrow mx-1">
                                <div class="shadow dropdown-list dropdown-menu dropdown-menu-end" aria-labelledby="alertsDropdown"></div>
                            </li>
                            <div class="d-none d-sm-block topbar-divider"></div>
                            <li class="nav-item dropdown no-arrow">
                                <div class="nav-item dropdown no-arrow"><a class="dropdown-toggle nav-link" aria-expanded="false" data-bs-toggle="dropdown" href="#"><img class="border rounded-circle img-profile" src="./assets/uploads/users/<?php if (isset($_SESSION['profile_image']) AND !empty($_SESSION['profile_image'])) { echo $_SESSION['profile_image']; } else { echo "_defaultUser.png"; }?>"></a>
                                    <div class="dropdown-menu shadow dropdown-menu-end animated--grow-in"><a class="dropdown-item" href="./profile-edit/"><i class="fas fa-cogs fa-sm fa-fw me-2 text-gray-400"></i>&nbsp;Mein Account <?php if (isset($_SESSION['username']) AND !empty($_SESSION['username'])) { echo "(".$_SESSION['username'].")"; }?></a>
                                        <div class="dropdown-divider"></div><a class="dropdown-item" href="./logout/"><i class="fas fa-sign-out-alt fa-sm fa-fw me-2 text-gray-400"></i>&nbsp;Abmelden</a>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                </nav>
                
                <div class="container-fluid">

                    <h5 class="text-dark mb-4">SYSTEM CHANGELOG</h5>
                    <div class="card shadow">
                    
                    <?php foreach ($changelogs as $post) { ?>
                        <div class="card-body" style="">
                          <div class="card shadow">
                              <div class="card-header py-3">
                                   <div class="row">
                                      <div class="col-xxl-12 offset-xxl-0">
                                      <h5><?=$post['date_added']?>: <b><?=$post['title']?></b></h5>
                                      </div>
                                  </div>
                              </div>
                              <div class="card-body" style="">
                                  <div class="row">

                                      <div class="col" style="height: auto;">
                                          <p><?=$post['description']?></p>
                                      </div>
                                  </div>
                              </div>
                          </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <footer class="bg-white sticky-footer">
                <div class="container my-auto">
                    <div class="text-center my-auto copyright"><span>Copyright © Solution4Care - developed by KLOSS.PK</span></div>
                </div>
            </footer>
        </div>
    </div>
    <script src="bs_assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="bs_assets/js/bs-init.js"></script>
    <script src="bs_assets/js/theme.js"></script>
    <script src="onscan.min.js"></script>
    <script src="notify.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/es6-shim/0.35.3/es6-shim.min.js"></script>
    <script src="assets/js/formvalidation/js/FormValidation.min.js"></script>
    <script src="assets/js/formvalidation/js/plugins/Tachyons.min.js"></script>
    <script>
      var fv;
    $(document).ready(function() {
      fv = FormValidation.formValidation(document.getElementById('assignmentForm'), {
        plugins: {
          declarative: new FormValidation.plugins.Declarative({ html5Input: true }),
          trigger: new FormValidation.plugins.Trigger({
                                event: "blur change keyup",
                                //threshold: 1,
                                //delay: 0,
                            })
          ,
          tachyons: new FormValidation.plugins.Tachyons(),
          //submitButton: new FormValidation.plugins.SubmitButton(),
          icon: new FormValidation.plugins.Icon({
            valid: 'fa fa-check',
            invalid: 'fa fa-times',
            validating: 'fa fa-refresh',
          })
        },
      });

    $.notify.defaults({ className: "success", hideDuration: 10000, style: 'bootstrap' });
    $(".baseStation").hide();

    function loadImei(imei) {
      $.get("zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+imei+"&action=load", function(data, status){
        //console.log("Data: " + data + "\nStatus: " + status);

        $("input").val("");
        $("#baseStationActionState").html("");
        $('#baseStationActionState').css("color", "black");
        $('#baseStationActionState').css("background-color", "white");
        fv.resetForm(true);

        if (typeof JSON.parse(data).data !== 'undefined') {
          $.notify("GELADEN: IMEI "+imei);
          data = JSON.parse(data).data;
          //console.log("data", data[0]);

          currentImei = data[0].imei;
          if (data[0].hardwareDeviceType !== "EV04" && data[0].hardwareDeviceType !== "EV07") {
            $(".baseStation").hide();
          } else {
            $(".baseStation").show();
          }
          $("#imeiInput").val(data[0].imei);
          $("#umoDeviceId").val(data[0].umoDeviceId);
          $("#umoDeviceIdInput").val(data[0].umoDeviceId);
          $("#hardwareDeviceTypeInput").val(data[0].hardwareDeviceType);
          if (data[0].active == 1) { $("#deviceStatusInput").val("Bereit zum Aufbau"); }
          else if (data[0].active == 2) { $("#deviceStatusInput").val("Angeschlossen"); }
          else { $("#deviceStatusInput").val(data[0].active); }

          if (data[0].simStatus == 1) { $("#simStatusInput").val("Bereit zur Aktivierung"); }
          else if (data[0].simStatus == 2) { $("#simStatusInput").val("Aktiv"); }
          else if (data[0].simStatus == 4) { $("#simStatusInput").val("Bereit zur Aktivierung"); }
          else if (data[0].simStatus == "-1") { $("#simStatusInput").val("Bereit zur Aktivierung"); }
          else { $("#simStatusInput").val("Unbekannt: '"+data[0].simStatus+"'"); }


          if (data[0].simOnlineStatus == 1) { $("#simOnlineStatusInput").val("Online"); }
          else if (data[0].simOnlineStatus == 0) { $("#simOnlineStatusInput").val("Offline"); }
          else { $("#simOnlineStatusInput").val("Unbekannt: '"+data[0].simOnlineStatus+"'"); }


          $("#homeWifiMac").val(data[0].homeWifiMac);
          $("#homeWifiLat").val(data[0].homeWifiLat);
          $("#homeWifiLng").val(data[0].homeWifiLng);
          $("#homeWifiDescr").val(data[0].homeWifiDescr);

          $("#homeBeaconMac").val(data[0].homeBeaconMac);
          $("#homeBeaconLat").val(data[0].homeBeaconLat);
          $("#homeBeaconLng").val(data[0].homeBeaconLng);
          $("#homeBeaconDescr").val(data[0].homeBeaconDescr);

          $("#baseStationLat").val(data[0].baseStationLat);
          $("#baseStationLng").val(data[0].baseStationLng);

          if (data[0].active == "2") {
            $("#deviceStatus").prop( "checked", true );
          } else {
            $("#deviceStatus").prop( "checked", false );
          }
          $("#msisdnInput").val(data[0].msisdn);
        } else {
          $.notify("FEHLER beim Laden von "+imei, "error");
          $("#imeiInput").val("");
          $("#baseStationActionState").html("");
          $("#baseStationActionState").html("");
        }
      });
    }

    function loadDeviceList() {
      $.get("zuw31sung4pi.php?&action=loadAll", function(data, status){
        //alert("Data: " + data + "\nStatus: " + status);
        data = JSON.parse(data).data;
        //console.log("data", data);
        $("#deviceTable").html("");
        $("#deviceTableUnassigned").html("");

        for(i=0;i<data.length;i++) {
          if (data[i].active === "1"){
            //console.log("active === 1");
            //console.log("trying to append: "+'<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
            $("#deviceTable").append('<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
          }
          else if (data[i].active === "2"){
            //console.log("active === 2");
            //console.log("trying to append: "+'<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
            $("#deviceTableUnassigned").append('<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
          } else {
            //console.log("NO, active === "+data[i].active);
          }
        }
      });
    }

    function trackBaseStationTaskId(taskId) {
      if (typeof taskId !== 'undefined') {
        $.get("zuw31sung4pi.php?action=baseStationTransmitStatus&taskId="+taskId, function(data, status){
        //alert("Data: " + data + "\nStatus: " + status);
        data = JSON.parse(data);
        //console.log("data", data);

        if (data.status === "done" && data.hardwareDeviceType === "EV07"){
            $("#baseStationActionState").html('Drücken Sie nun innerhalb von 2min an der Ladestation die "Call2" Taste bis Sie die Sprachdurchsage "Paarung erfolgreich" hören! Sobald die Ladestation blau leuchtet sind die Koordinaten programmiert.');
            $('#baseStationActionState').css("color", "white");
            $('#baseStationActionState').css("background-color", "green");
            setTimeout(function () {
              $("#baseStationActionState").html("");
              $('#baseStationActionState').css("color", "black");
              $('#baseStationActionState').css("background-color", "white");
            }, 120000);
          } else if (data.status === "done" && data.hardwareDeviceType !== "EV07"){
            $("#baseStationActionState").html("ERFOLGREICH VERSENDET!");
            $('#baseStationActionState').css("color", "white");
            $('#baseStationActionState').css("background-color", "green");
            setTimeout(function () {
              $("#baseStationActionState").html("");
              $('#baseStationActionState').css("color", "black");
              $('#baseStationActionState').css("background-color", "white");
            }, 120000);
          } else if (data.status === "undone"){
            $('#baseStationActionState').css("color", "black");
            $('#baseStationActionState').css("background-color", "orange");
            $("#baseStationActionState").html("SMS ist unterwegs!");
            setTimeout(function () {
              trackBaseStationTaskId(taskId);
            }, 1000);
          } else if (data.status === "error"){
            $('#baseStationActionState').css("color", "white");
            $('#baseStationActionState').css("background-color", "red");
            $("#baseStationActionState").html("Fehler SMS Versand!");
            setTimeout(function () {
              $("#baseStationActionState").html("");
              $('#baseStationActionState').css("color", "black");
              $('#baseStationActionState').css("background-color", "white");
            }, 120000);
          } else {
            console.log("unknown: ",data);
            //console.log("NO, active === "+data[i].active);
          }
      });
      }
    }


    var currentImei = "";
    var imeiInput = document.getElementById("imeiScanInput");
    onScan.attachTo(imeiInput, {
    suffixKeyCodes: [13], // enter-key expected at the end of a scan
    avgTimeByChar: 500,
    timeBeforeScanTest: 500,
    reactToPaste: true,
    reactToKeydown: true, // Compatibility to built-in scanners in paste-mode (as opposed to keyboard-mode)
    onScan: function(sCode, iQty) { // Alternative to document.addEventListener('scan')
      //console.log("WE DID SCAN: "+sCode);
      loadImei(sCode);
    }
    });

    $( "#saveButton" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=saveData", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: Daten für IMEI "+currentImei+" gespeichert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER beim Speichern von IMEI "+currentImei, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#saveSubmitButton" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=saveSubmit", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: Daten für IMEI "+currentImei+" gespeichert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER beim Speichern von IMEI "+currentImei, "error");
          console.log(decodedData);
        }
        if (decodedData.simUpdateStatus === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" konfiguriert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#baseStationTransmit" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=baseStationTransmit", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG:  "+currentImei+" gespeichert!");
          loadDeviceList();
          trackBaseStationTaskId(decodedData.taskId);
        } else {
          $.notify("FEHLER BaseStationTransmit von IMEI "+currentImei+": "+decodedData.error, "error");
          console.log(decodedData.error);
        }
        /*
        if (decodedData.simUpdateStatus === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" konfiguriert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
        */
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#enableSIM" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=enableSIM", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" aktiviert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#disableSIM" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=disableSIM", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" deaktiviert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#returnDevice" ).on( "click", function() {
      $('#returnModal').modal('show');
    });



    $( ".closeReturnModal" ).on( "click", function() {

      $("#returnModal").modal("hide");

    });

    $( ".closeShutdownModal" ).on( "click", function() {

      $("#shutdownModal").modal("hide");

    });

    $( "#confirmReturnModal" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=returnDevice", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: IMEI "+currentImei+" retourniert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei Geräte-Retournierung IMEI "+currentImei, "error");
          console.log(decodedData);
        }
        $("#returnModal").modal("hide");
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

$( "#confirmShutdownModal" ).on( "click", function() {

  if (currentImei !== "") {
      $.post( "zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=shutdownDevice", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: Shutdown-SMS an IMEI "+currentImei+" eingeplant!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei Geräte-Shutdown IMEI", "error");
          console.log(decodedData);
        }
        $("#shutdownModal").modal("hide");
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });



    $( "#shutdownDevice" ).on( "click", function() {

      $('#shutdownModal').modal('show');

    });

    $("#homeWifiMac, #homeBeaconMac").on("keyup blur change", function(event) {

      var limitField = $(this).val().trim().length;
      var limit = "17";

      if (event.keyCode != 8) {
        var mac_value = $(this).val().trim().concat(':');
        switch(limitField) {
          case 2:
          case 5:
          case 8:
          case 11:
          case 14:
            $(this).val(mac_value);
            break;
        }
      }

      if (limitField > limit) {
        $("#mac").val($(this).val().trim().substring(0, limit));
      }
    });

    loadDeviceList();

    setInterval(function () {

      loadDeviceList();

    }, 10000);

  });

    </script>
    <?php include 'changelogWidget.php'; ?>
</body>

</html>
