<?php

require('Medoo.php');
use \Medoo\Medoo;

function convert_battery_level($value) {
    // ensure $value is between 1 and 10
    //$value = max(1, min(10, $value));

    // calculate the battery level scale
    //$battery_scale = round($value / 10 * 7) + 1;

    return $value;
}

function convertDateTimeToISO($dateTimeString) {
  $viennaTimeZone = new DateTimeZone('Europe/Vienna');
  $dateTime = new DateTime($dateTimeString, $viennaTimeZone);
  $utcTimeZone = new DateTimeZone('UTC');
  $dateTime->setTimezone($utcTimeZone);
  return $dateTime->format('Y-m-d\TH:i:s.u\Z');
}

function fix_url($url) {
  $url = trim($url);
  // Check if the URL is valid
  if (filter_var($url, FILTER_VALIDATE_URL) === false) {
    //return false;
    if (strpos($url, 'http://') === false && strpos($url, 'https://') === false) {
      $url = 'http://' . $url;
      if (filter_var($url, FILTER_VALIDATE_URL) !== false) {
          return $url;
        }
    }
  }

  // Check if the URL has http:// or https:// at the beginning
  echo "we will return $url<br>";
  return $url;
}

function getRedirectUrl ($url) {
  //echo "url to use for redirect: ".fix_url($url);
    stream_context_set_default(array(
        'http' => array(
            'method' => 'HEAD'
        )
    ));
    $headers = get_headers(fix_url($url), 1);
    echo "headers of $url ";
    print_r($headers);
    echo "<br>";
    if ($headers !== false && isset($headers['Location'])) {
        return $headers['Location'];
    }

    echo "no redirect URL found<br>";
    return false;
}

function extractDateTimeAndBatteryLevel($str) {
  $dateTime = null;
  $batteryLevel = null;

  // Match for dateTime in format: mm/dd/yyyy hh:mm:ss
  preg_match('/:(\d{2}\/\d{2}\/\d{4} \d{2}:\d{2}:\d{2})/', $str, $matches);
  if (count($matches) > 0) {
    $dateTime = $matches[1];
    //$dateTime = str_replace("/","-",$dateTime);
    $dateTime = convertDateTimeToISO($dateTime,'Y-m-d H:i:s');
  }

  // Match for batteryLevel in format: 0-100%
  preg_match('/\d{1,3}%/', $str, $matches);
  if (count($matches) > 0) {
    $batteryLevel = $matches[0];
    $batteryLevel = str_replace("%","",$batteryLevel);
    //auskommentiert weil nicht notwendig:
    //$batteryLevel = round(intVal($batteryLevel) / 10);
    //$batteryLevel = convert_battery_level($batteryLevel);
  }

  return array('dateTime' => $dateTime, 'batteryLevel' => $batteryLevel);
}

function processLocationSms($string, $deviceArray, $database) {
  $pattern1 = '/\s*smart-locator\.com\/web\/geolocation\/wg\/[-A-Za-z0-9._~:\/?#@!$&\'()*+,;=%]+\s*/';
  // old pattern: $pattern1 = '/www\.smart-locator\.com\/web\/geolocation\/wg\/[A-Za-z0-9\-_]+={2,}/';
  $pattern2 = '/www\.google\.com\/maps\?q=-?[0-9.]+,-?[0-9.]+/';

  $pattern3 = '/Lage:(.*?)[\r\n]/';

  if (preg_match_all($pattern1, $string, $smartLocMatches)) {

    $finalRedirectUrl = getRedirectUrl($smartLocMatches[0][0]);
    //echo "finalRedirectURL: ".$finalRedirectUrl;
    $dateTimeBattery = extractDateTimeAndBatteryLevel($string);
    $latLng = extract_lat_lng_from_google_maps_uri($finalRedirectUrl);
    //echo "latLng: ";
    //print_r($latLng);
    print_r(array(
      "lat" => $latLng['lat'],
      "lng" => $latLng['lng'],
      "battery" => $dateTimeBattery['batteryLevel'],
      "dateTime" => $dateTimeBattery['dateTime']
    ));
    return array(
      "lat" => $latLng['lat'],
      "lng" => $latLng['lng'],
      "battery" => $dateTimeBattery['batteryLevel'],
      "dateTime" => $dateTimeBattery['dateTime']
    );
  }
  if (preg_match_all($pattern2, $string, $googleMapMatches)) {
    //echo "match2";
    print_r(extract_lat_lng_from_google_maps_uri($string));
    //echo "finalRedirectURL: ".$finalRedirectUrl;
    $dateTimeBattery = extractDateTimeAndBatteryLevel($string);
    print_r(array(
      "lat" => extract_lat_lng_from_google_maps_uri($string)['lat'],
      "lng" => extract_lat_lng_from_google_maps_uri($string)['lng'],
      "battery" => $dateTimeBattery['batteryLevel'],
      "dateTime" => $dateTimeBattery['dateTime']
    ));
    return array(
      "lat" => extract_lat_lng_from_google_maps_uri($string)['lat'],
      "lng" => extract_lat_lng_from_google_maps_uri($string)['lng'],
      "battery" => $dateTimeBattery['batteryLevel'],
      "dateTime" => $dateTimeBattery['dateTime']
    );
  }
  if (preg_match_all($pattern3, $string, $homeWifiMatches)) {
    echo "HOME WIFI FOUND<br>";

    $homeWifiName = $homeWifiMatches[1][0];

    if ($deviceArray['homeWifiDescr'] == $homeWifiName) {
      $dateTimeBattery = extractDateTimeAndBatteryLevel($string);
      print_r(array(
        "lat" => $deviceArray['homeWifiLat'],
        "lng" => $deviceArray['homeWifiLng'],
        "battery" => $dateTimeBattery['batteryLevel'],
        "dateTime" => $dateTimeBattery['dateTime'],
        "description" => $homeWifiName
      ));
      return array(
        "lat" => $deviceArray['homeWifiLat'],
        "lng" => $deviceArray['homeWifiLng'],
        "battery" => $dateTimeBattery['batteryLevel'],
        "dateTime" => $dateTimeBattery['dateTime'],
        "description" => $homeWifiName
      );
    }

  }
  echo false;
  return false;
}

function extract_lat_lng_from_google_maps_uri($uri) {
  //echo "latLng: $uri";
  $lat_lng = array();

  // Extract the latitude and longitude from the URI
  preg_match('/q=(-?[0-9.]+),(-?[0-9.]+)/', $uri, $matches);

  // If the latitude and longitude are found, add them to the array
  if (count($matches) == 3) {
    $lat_lng['lat'] = $matches[1];
    $lat_lng['lng'] = $matches[2];
  }

  return $lat_lng;
}


$database = new \Medoo\Medoo([
  // [required]
  'type' => 'mysql',
  'host' => 'localhost',
  'database' => 'gpsTest',
  'username' => 'gpsTest',
  'password' => '6HNV*=?U',

  // [optional]
  'charset' => 'utf8mb4',
  'collation' => 'utf8mb4_general_ci',
  'port' => 3306,

  // [optional] The table prefix. All table names will be prefixed as PREFIX_table.
//	'prefix' => 'PREFIX_',

  // [optional] To enable logging. It is disabled by default for better performance.
  //'logging' => true,

  // [optional]
  // Error mode
  // Error handling strategies when the error has occurred.
  // PDO::ERRMODE_SILENT (default) | PDO::ERRMODE_WARNING | PDO::ERRMODE_EXCEPTION
  // Read more from https://www.php.net/manual/en/pdo.error-handling.php.
  'error' => PDO::ERRMODE_SILENT,

  // [optional]
  // The driver_option for connection.
  // Read more from http://www.php.net/manual/en/pdo.setattribute.php.

  'option' => [
    PDO::ATTR_CASE => PDO::CASE_NATURAL
  ],

  // [optional] Medoo will execute those commands after the database is connected.
  /*
  'command' => [
    'SET SQL_MODE=ANSI_QUOTES'
  ]
  */
]);




$data = $database->select("devices", "*",
[ "msisdn" => "423664368115" ]
);


if (count($data) === 1) {

  $data = $data[0];

  //print_r($data);
  echo "<br>";

  echo "TEST:<br>";
$msg = 'HomeWifi:
Lokalzeit:05/09/2023 09:49:13
Lage:WIFI Office
Batterie:100%';

echo "<br>";

    $processMessage = processLocationSms($msg,$data,$database);

    echo "processMessage === ";
    print_r($processMessage);

}

      /*

  $data = $database->select("devices", "*",
  [ "organisationId" => $orgId ]
  );

  if (count($data) > 0) {

    $data[0]['simStatus'] = getSimStateFromICCID(getSimByMSISDN($data[0]['msisdn']));

    echo json_encode(array("data" => $data));
  } else {
    echo json_encode(array("error" => "devices not found"));
  }
  */


?>
