<?php

require('Medoo.php');

use \Medoo\Medoo;

$database = new \Medoo\Medoo([
	// [required]
  'type' => 'mysql',
	'host' => 'localhost',
	'database' => 'gpsTest',
	'username' => 'gpsTest',
	'password' => '6HNV*=?U',

	// [optional]
	'charset' => 'utf8mb4',
	'collation' => 'utf8mb4_general_ci',
	'port' => 3306,

	// [optional] The table prefix. All table names will be prefixed as PREFIX_table.
//	'prefix' => 'PREFIX_',

	// [optional] To enable logging. It is disabled by default for better performance.
	//'logging' => true,

	// [optional]
	// Error mode
	// Error handling strategies when the error has occurred.
	// PDO::ERRMODE_SILENT (default) | PDO::ERRMODE_WARNING | PDO::ERRMODE_EXCEPTION
	// Read more from https://www.php.net/manual/en/pdo.error-handling.php.
	'error' => PDO::ERRMODE_EXCEPTION,

	// [optional]
	// The driver_option for connection.
	// Read more from http://www.php.net/manual/en/pdo.setattribute.php.

  'option' => [
		PDO::ATTR_CASE => PDO::CASE_NATURAL
	],

	// [optional] Medoo will execute those commands after the database is connected.
  /*
  'command' => [
		'SET SQL_MODE=ANSI_QUOTES'
	]
  */
]);

$targetOrganisationId = 10;
$targetActiveState = 1;

$commaSeparated = "861352060032094;861352060032235;861629050186786;861629050188899;861352060031591;861629050185580;861352060032193;861352060032177;861352060033324;861352060032334;861352060050658;861629050186760;861629050188840;861352060032268;861629050185697;861352060032466;861352060034082;861629050185192;861352060032136;861352060032870;861352060034074;861629050185630;861352060031492;861352060034173;861629050188857;861352060034058;861629050185754;861352060031518;861352060032540;861352060031237;861352060034256;861629050188782;861352060032375;861352060031211;861352060031757;861352060033175;861352060031625;861352060032557;861629050188931;861629050185713;861629050185606;861629050185655;861629050188865;861352060032011;861352060032417;861352060034116;861629050185093;861352060034132;861352060034090;861629050185739;861352060033290;861629050185119;861629050185671;861629050188824;861352060034298;861629050186323;861629050185663;861629050186646;861352060034249;861629050185622;861629050185424;861629050186422;861629050187933;861629050186588;861629050188477;861629050187859;861629050186612;861629050186877;861629050187545;861629050187594;861629050186596;861352060040477;861352060031864;861629050189707;861629050185069;861352060033506;861629050187404;861629050187024;861352060033464;861352060050898;861629050186869;861629050187446;861352060032631;861629050187271;861352060032607;861629050187735;861629050187248;861629050187487;861352060049429;861352060049486;861352060049387;861352060050914;861352060033357;861352060049221;861352060032581;861352060032805;861352060049403;861352060032755;861352060033530;861352060050989;861352060049544;861352060049395;861352060049213;861352060050823;861352060049338;861352060033472;861629050186984;861629050188873;861629050187016;861629050184229;861352060033639;861352060049098;861352060033720;861352060049114;861352060032821;861629050186992;861629050187495;861352060033456;861352060033365;861352060033415;861352060033779;861352060033852;861352060032573;861629050187602;861352060033340;861629050187792;861352060033704;861352060033761;861352060033563;861629050185960;861352060033753;861629050185986;861352060033845;861352060033795;861629050188923;861352060033860;861352060033886;861352060033712;861352060033654;861629050186281;861352060033597;861352060033829;861352060033373;861352060033696;861352060033803;861352060040436;861352060033969;861352060033621;861352060040451;861629050189095;861629050189723;861629050184286;861352060033423;861352060033381;861352060033738;861629050189749;861629050187586;861629050188907;861629050188881;861629050189061;861629050189079;861629050189020;861629050189004;861629050185507;861629050188980;861352060033688;861629050187669;861352060033514;861629050187222;861352060033936;861629050187479;861352060033787;861629050187750;861629050186935;861352060033498;861352060033662;861629050189087;861629050184948;861352060033647;861352060033951;861629050185598;861352060032532;861352060031922;861352060032946;861629050187008;861352060031476;861352060032359;861352060032383;861352060033027;861352060031286;861352060032490;861352060050724;861629050187362;861352060031021;861352060031849;861352060033035;861352060032326;861352060032904;861352060031195;861352060032987;861352060031153;861352060034165;861629050188766;861352060032342;861629050185614;861352060033308;861352060032110;861352060032508;861352060032243;861629050185887;861352060032474;861352060033258;861352060033167;861352060031484;861352060034207;861629050185010;861352060032078;861352060033076;861352060032961;861352060031146;861629050187354;861352060032920;861352060050625;861352060031062;861352060032862;861352060031765;861352060031799;861352060031872;861352060032300;861352060034181;861352060032516;861352060032896;861352060032276;861629050186679;861352060031740;861352060033019;861352060031575;861352060032219;861352060032458;861352060031773;861352060032730;861352060031294;861352060032979;861352060049296;861352060049148;861352060049189;861352060049197;861352060049411;861352060049445;861352060031534;861352060032813;861352060050906;861352060049262;861352060050831;861352060031310;861352060031583;861352060032391;861352060032714;861352060049379;861352060049155;861352060031377;861352060036822;861629050187503;861629050187206;861352060032201;861629050188634;861629050186471;861629050186554;861352060034017;861629050186943;861352060049247;861629050185747;861352060049437;861352060049205;861352060032771;861352060031179;861352060050799;861629050187552;861352060049528;861352060031930;861352060050971;861352060032763;861352060032847;861352060049288;861352060050872;861352060036616;861352060034868;861352060035782;861352060031567;861352060035188;861352060033548;861629050187768;861352060034033;861629050184989;861629050188949;861629050188212;861629050184971;861629050188261;861352060031351;861352060031559;861629050184021;861629050185309;861629050184625;861352060034363;861629050184666;861352060037127;861352060034728;861629050184211;861629050185267;861629050184302;861352060034470;861352060050732;861352060034561;861629050184534;861352060050435;861629050185366;861352060034587;861629050184674;861629050185291;861629050184641;861352060033522;861629050185200;861352060050328;861352060034066;861629050185317;861629050184880;861352060049692;861629050185127;861352060049031;861352060034280;861352060050930;861629050184724;861629050184682;861629050184153;861629050185150;861352060034645;861352060050203;861352060034306;861352060037218;861629050185531;861629050184112;861629050184344;861629050184690;861629050185275;861629050185176;861629050184070;861352060034744;861352060031781;861352060031393;861352060034231;861352060033571;861352060036830;861352060034686;861352060037242;861352060034892;861629050184765;861629050184146;861352060034330;861352060036814;861352060037226;861629050186117;861629050186372;861352060050088;861352060034348;861352060050807;861629050186075;861629050186620;861352060050187;861352060034439;861629050184831;861352060050963;861352060031989;861352060050484;861629050185036;861352060049981;861352060049015;861629050185762;861352060049841;861352060049627;861352060049940;861352060050054;861352060049932;861352060049643;861352060050302;861352060049775;861352060049759;861629050184997;861629050186182;861629050186034;861352060050062;861352060050005;861352060031856;861352060034611;861352060049916;861352060049734;861352060034777;861352060049866;861352060049718;861352060034108;861352060049668;861352060050237;861352060049650;861352060049908;861352060049999;861629050186349;861352060034272;861352060049619;861352060033084;861629050185168;861629050185184;861629050185085;861352060034678;861352060034355;861352060033449;861629050187297;861352060032185;861629050185143;861352060034140;861352060050039;861352060050021;861629050186158;861629050186042;861629050186752;861629050186166;861629050186414;861629050186729;861629050186687;861629050188592;861629050186398;861629050186794;861629050186976;861629050186851;861629050185499;861629050188832;861629050186778;861629050186059;861629050186711;861629050187339;861629050186638;861629050186539;861629050187370;861629050186836;861629050187255;861629050186802;861629050185473;861629050185481;861629050189285;861629050186513;861629050186133;861629050186703;861629050187347;861629050186653;861352060049577;861629050187214;861629050187107;861629050187172;861629050187651;861629050186919;861629050186455;861629050188493;861629050186018;861629050185556;861352060033274;861629050188097;861629050187305;861352060031120;861352060032672;861352060032995;861352060032649;861629050187289;861629050186828;861352060049080;861629050187396;861629050187115;861629050187453;861352060031047;861629050187321;861629050187412;861352060050997;861629050187198;861352060034314;861629050186000;861629050185259;861352060034660;861629050184823;861629050186315;861352060034322;861629050184088;861629050184781;861629050184062;861352060034413;861629050185341;861352060034629;861352060034603;861629050184708;861629050185218;861629050184633";
//$commaSeparated = "";

$imeiArray = explode(";", $commaSeparated);
$errorArray = array();
$successArray = array();

foreach ($imeiArray as $row) {
    if (isset($row) AND !empty($row)) {
        $imeiExist = $database->select("devices", "*", [ "imei" => $row ]);
        if (count($imeiExist) === 1) {
            echo "[DB] IMEI $failedImei found inside database.<br>";
            $update = $database->update("devices", [
                "organisationId" => $targetOrganisationId,
                "active" => $targetActiveState,
            ], [ "imei" => $row ]);
            if ($update->rowCount() > 0) {
                array_push($errorArray, $row);
            } else {
                array_push($errorArray, $row);
            }
        } else {
            echo "[DB-ERROR] IMEI $row does not exist in database.<br>";
        }
    } else {
        echo "[DB-ERROR] IMEI $row is empty string.Why?!<br>";
    }
}

if (count($errorArray) > 0) {
    echo "ERRORS:";
    foreach ($errorArray as $failedImei) {
        echo "[ERROR] IMEI $failedImei did not update settings.<br>";
    }
} else {
    
    if (count($successArray) > 0) {
        echo "No errors while importing - all successfull!<br>";
        foreach ($successArray as $successfulImei) {
            echo "[SUCCESS] IMEI $successfulImei did update settings.<br>";
        }
    } else {
        "[INFO] Success array has 0 rows.<br>";
    }
    
}


?>