<?php

require('Medoo.php');

include './assets/layouts/header.php';

use \Medoo\Medoo;

if(check_logged_in()) {

$orgId = $_SESSION['organisation_id'];

} else {
  exit();
}

$database = new \Medoo\Medoo([
	// [required]
  'type' => 'mysql',
	'host' => 'localhost',
	'database' => 'gpsTest',
	'username' => 'gpsTest',
	'password' => '6HNV*=?U',

	// [optional]
	'charset' => 'utf8mb4',
	'collation' => 'utf8mb4_general_ci',
	'port' => 3306,

	// [optional] The table prefix. All table names will be prefixed as PREFIX_table.
//	'prefix' => 'PREFIX_',

	// [optional] To enable logging. It is disabled by default for better performance.
	//'logging' => true,

	// [optional]
	// Error mode
	// Error handling strategies when the error has occurred.
	// PDO::ERRMODE_SILENT (default) | PDO::ERRMODE_WARNING | PDO::ERRMODE_EXCEPTION
	// Read more from https://www.php.net/manual/en/pdo.error-handling.php.
	'error' => PDO::ERRMODE_EXCEPTION,

	// [optional]
	// The driver_option for connection.
	// Read more from http://www.php.net/manual/en/pdo.setattribute.php.

  'option' => [
		PDO::ATTR_CASE => PDO::CASE_NATURAL
	],

	// [optional] Medoo will execute those commands after the database is connected.
  /*
  'command' => [
		'SET SQL_MODE=ANSI_QUOTES'
	]
  */
]);




?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title>Table - Brand</title>
    <link rel="stylesheet" href="bs_assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i&amp;display=swap">
    <link rel="stylesheet" href="bs_assets/fonts/fontawesome-all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</head>

<body id="page-top">
    <div id="wrapper">
        <nav class="navbar navbar-dark align-items-start sidebar sidebar-dark accordion bg-gradient-primary p-0">
            <div class="container-fluid d-flex flex-column p-0"><a class="navbar-brand d-flex justify-content-center align-items-center sidebar-brand m-0" href="#">
                    <div class="sidebar-brand-icon rotate-n-15"></div>
                    <div class="sidebar-brand-text mx-3"><span>SOLUTION4CARE</span></div>
                </a>
                <hr class="sidebar-divider my-0">
                <ul class="navbar-nav text-light" id="accordionSidebar">
                    <!-- <li class="nav-item"><a class="nav-link" href="index.html"><i class="fas fa-tachometer-alt"></i><span>Übersicht</span></a></li> -->
                    <li class="nav-item"><a class="nav-link" href="profile.html"><i class="fas fa-plus-circle"></i><span>Geräte zuweisen</span></a></li>
                    <li class="nav-item"></li>
                </ul>
                <div class="text-center d-none d-md-inline"><button class="btn rounded-circle border-0" id="sidebarToggle" type="button"></button></div>
            </div>
        </nav>
        <div class="d-flex flex-column" id="content-wrapper">
            <div id="content" style="width: 100%;">
                <nav class="navbar navbar-light navbar-expand bg-white shadow mb-4 topbar static-top">
                    <div class="container-fluid"><button class="btn btn-link d-md-none rounded-circle me-3" id="sidebarToggleTop" type="button"><i class="fas fa-bars"></i></button><span class="fw-bold d-none d-lg-inline me-2 text-gray-600 small">CUSTOMER CONSOLE</span>
                        <ul class="navbar-nav flex-nowrap ms-auto">
                            <li class="nav-item dropdown d-sm-none no-arrow"><a class="dropdown-toggle nav-link" aria-expanded="false" data-bs-toggle="dropdown" href="#"><i class="fas fa-search"></i></a>
                                <div class="dropdown-menu dropdown-menu-end p-3 animated--grow-in" aria-labelledby="searchDropdown">
                                    <form class="me-auto navbar-search w-100">
                                        <div class="input-group"><input class="bg-light form-control border-0 small" type="text" placeholder="Search for ...">
                                            <div class="input-group-append"><button class="btn btn-primary py-0" type="button"><i class="fas fa-search"></i></button></div>
                                        </div>
                                    </form>
                                </div>
                            </li>
                            <li class="nav-item dropdown no-arrow mx-1"></li>
                            <li class="nav-item dropdown no-arrow mx-1">
                                <div class="shadow dropdown-list dropdown-menu dropdown-menu-end" aria-labelledby="alertsDropdown"></div>
                            </li>
                            <div class="d-none d-sm-block topbar-divider"></div>
                            <li class="nav-item dropdown no-arrow">
                                <div class="nav-item dropdown no-arrow"><a class="dropdown-toggle nav-link" aria-expanded="false" data-bs-toggle="dropdown" href="#"><img class="border rounded-circle img-profile" src="bs_assets/img/avatars/avatar1.jpeg"></a>
                                    <div class="dropdown-menu shadow dropdown-menu-end animated--grow-in"><a class="dropdown-item" href="#"><i class="fas fa-cogs fa-sm fa-fw me-2 text-gray-400"></i>&nbsp;User Settings</a>
                                        <div class="dropdown-divider"></div><a class="dropdown-item" href="#"><i class="fas fa-sign-out-alt fa-sm fa-fw me-2 text-gray-400"></i>&nbsp;Logout</a>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </nav>
                <div class="container-fluid">
                    <h5 class="text-dark mb-4">Gerät(e) einem Endkunden zuweisen</h5>
                    <div class="card shadow">
                        <div class="card-header py-3">
                            <div class="row">
                                <div class="col"><small class="form-text">IMEI eingeben / scannen:</small><input id="imeiScanInput" name="imeiScanInput" style="width: 100%;" placeholder="...hier klicken und IMEI scannen ODER copy & pasten..." value=""></div>
                            </div>
                        </div>
                        <div class="card-body" style="min-height: 66vh;">
                            <div class="row">
                                <div class="col">
                                  <form id="assignmentForm" action="" method="post">
                                    <div class="row" style="margin-bottom: 0px;">
                                        <div class="col">
                                            <h4 style="font-size: 1rem;">Gerät</h4>
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;">
                                        <div class="col" style="margin-bottom: 4px;">
                                            <h5 style="margin-bottom: 0px;font-size: .8rem;">IMEI</h5><input id="imeiInput" name="imeiInput" type="text" style="width: 100%;background: rgb(242,242,242);font-size: .8rem;border-radius: 3px;border-width: 1px;" readonly disabled value="" placeholder="">
                                        </div>
                                    </div>
                                    <div class="row" style="font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;">UMO Geräte-ID</h5><input id="umoDeviceId" name="umoDeviceId" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" readonly disabled>
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 0px;font-size: .8rem;">

                                        <div class="col" style="font-size: .8rem;">
                                            <div class="row" style="font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">Gerätetyp</h5><input id="hardwareDeviceTypeInput" name="hardwareDeviceTypeInput" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" readonly disabled>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">Status</h5><input id="deviceStatusInput" name="deviceStatusInput" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" placeholder="" readonly disabled>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">Telefonnummer</h5><input id="msisdnInput" name="msisdnInput" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" placeholder="" readonly disabled>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <div class="row">
                                                        <div class="col">
                                                            <div class="row">
                                                                <div class="col">
                                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">SIM sofort aktivieren?</h5>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col"><input id="deviceStatus" name="deviceStatus" type="checkbox" style="border-width: 2px;border-radius: 3px;" checked></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">UMO Geräte-ID</h5><input id="umoDeviceIdInput" name="umoDeviceIdInput" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="" value="">
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI Router MAC-Adresse</h5><input id="homeWifiMac" name="homeWifiRouterMac"  type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value="">
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI Koordinate Latitude</h5><input id="homeWifiLat" name="homeWifiLat" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value="">
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI Koordinate Longitude</h5><input id="homeWifiLng" name="homeWifiLng" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value="">
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI Beschreibung des Orts:</h5><input id="homeWifiDescr" name="homeWifiDescr" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="">
                                        </div>
                                    </div>

                                    <!--
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeBeacon Koordinate MAC-Adresse</h5><input type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value="">
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeBeacon&nbsp;Koordinate Longitude</h5><input type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value="">
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeBeacon&nbsp;Koordinate Latitude</h5><input type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value="">
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeBeacon&nbsp;Beschreibung des Orts</h5><input type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="Schlafzimmer @Home" value="">
                                        </div>
                                    </div>
                                      -->
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;"><button id="assignButton" class="btn btn-primary" type="button">Gerät zuweisen</button></div>
                                    </div>

                                    <div></div>
                                  </form>
                                </div>
                                <div class="col" style="height: auto;">
                                    <div>
                                        <ul class="nav nav-tabs" role="tablist">
                                            <li class="nav-item" role="presentation"><a class="nav-link active" role="tab" data-bs-toggle="tab" href="#tab-1" style="font-size: .7rem;">auf Lager</a></li>
                                            <li class="nav-item" role="presentation" style="font-size: .7rem;"><a class="nav-link" role="tab" data-bs-toggle="tab" href="#tab-2" style="font-size: .7rem;">bereits zugewiesen</a></li>
                                        </ul>
                                        <div class="tab-content" style="max-height: 50vh;overflow: scroll;">
                                            <div class="tab-pane active" role="tabpanel" id="tab-1">
                                                <div class="table-responsive fs-6">
                                                    <table class="table">
                                                        <thead>
                                                            <tr>
                                                                <th style="font-size: .7rem;">IMEI</th>
                                                                <th style="font-size: .7rem;">MSISDN</th>
                                                                <th style="font-size: .7rem;">TYP</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="deviceTable" style="font-size: .7rem;">
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <div class="tab-pane" role="tabpanel" id="tab-2">
                                                <div class="table-responsive fs-6">
                                                    <table class="table">
                                                        <thead>
                                                            <tr>
                                                                <th style="font-size: .7rem;">IMEI</th>
                                                                <th style="font-size: .7rem;">MSISDN</th>
                                                                <th style="font-size: .7rem;">TYP</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="deviceTableUnassigned" style="font-size: .7rem;">
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <footer class="bg-white sticky-footer">
                <div class="container my-auto">
                    <div class="text-center my-auto copyright"><span>Copyright © INFIN_IT</span></div>
                </div>
            </footer>
        </div>
    </div>
    <script src="bs_assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="bs_assets/js/bs-init.js"></script>
    <script src="bs_assets/js/theme.js"></script>
    <script src="onscan.min.js"></script>
    <script src="notify.min.js"></script>
    <script>

    $.notify.defaults({ className: "success", hideDuration: 10000, style: 'bootstrap' });

    function loadImei(imei) {
      $.get("zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+imei, function(data, status){
        //console.log("Data: " + data + "\nStatus: " + status);
        if (typeof JSON.parse(data).data !== 'undefined') {
          //$.notify("GELADEN: IMEI "+imei);
          data = JSON.parse(data).data;
          //console.log("data", data[0]);
          currentImei = data[0].imei;
          $("#imeiInput").val(data[0].imei);
          $("#umoDeviceId").val(data[0].umoDeviceId);
          $("#umoDeviceIdInput").val(data[0].umoDeviceId);
          $("#hardwareDeviceTypeInput").val(data[0].hardwareDeviceType);
          $("#deviceStatusInput").val(data[0].active);
          if (data[0].active == "2") {
            $("#deviceStatus").prop( "checked", true );
          } else {
            $("#deviceStatus").prop( "checked", false );
          }
          $("#msisdnInput").val(data[0].msisdn);
        } else {
          $.notify("FEHLER beim Laden von "+imei, "error");
        }
      });
    }

    function loadDeviceList() {
      $.get("m4ndanten4pi.php?token=f48r7z4f784348fu33ß9e2r2&orgId="+"<?=$orgId?>", function(data, status){
        //alert("Data: " + data + "\nStatus: " + status);
        data = JSON.parse(data);
        //console.log("data", data);
        $("#deviceTable").html("");
        $("#deviceTableUnassigned").html("");

        for(i=0;i<data.length;i++) {
          if (data[i].active === "1") {
            //console.log("active === 1");
            //console.log("trying to append: "+'<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
            $("#deviceTable").append('<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
          }
          else if (data[i].active === "2") {
            //console.log("active === 2");
            //console.log("trying to append: "+'<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
            $("#deviceTableUnassigned").append('<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
          } else {
            //console.log("NO, active === "+data[i].active);
          }
        }
      });
    }


    var currentImei = "";
    var imeiInput = document.getElementById("imeiScanInput");
    onScan.attachTo(imeiInput, {
    suffixKeyCodes: [13,13,13], // enter-key expected at the end of a scan
    reactToPaste: true, // Compatibility to built-in scanners in paste-mode (as opposed to keyboard-mode)
    onScan: function(sCode, iQty) { // Alternative to document.addEventListener('scan')
      //console.log("WE DID SCAN: "+sCode);
      loadImei(sCode);

    },
    onKeyDetect: function(iKeyCode){ // output all potentially relevant key events - great for debugging!
        //console.log('Pressed: ' + iKeyCode);
    }
    });


    $( "#assignButton" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "zuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: IMEI "+currentImei+" konfiguriert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER beim Speichern von IMEI "+currentImei, "error");
          console.log(decodedData);
        }
        if (decodedData.simUpdateStatus === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" konfiguriert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    loadDeviceList();

    setInterval(function () {

      loadDeviceList();

    }, 10000);

    </script>
</body>

</html>
