<?php

//echo "HELLO";
include './assets/layouts/header.php';

require('Medoo.php');
use \Medoo\Medoo;

if(check_logged_in()) {
  $database = new \Medoo\Medoo([
    // [required]
    'type' => 'mysql',
    'host' => 'localhost',
    'database' => 'gpsTest',
    'username' => 'gpsTest',
    'password' => '6HNV*=?U',

    // [optional]
    'charset' => 'utf8mb4',
    'collation' => 'utf8mb4_general_ci',
    'port' => 3306,

    // [optional] The table prefix. All table names will be prefixed as PREFIX_table.
  //	'prefix' => 'PREFIX_',

    // [optional] To enable logging. It is disabled by default for better performance.
    //'logging' => true,

    // [optional]
    // Error mode
    // Error handling strategies when the error has occurred.
    // PDO::ERRMODE_SILENT (default) | PDO::ERRMODE_WARNING | PDO::ERRMODE_EXCEPTION
    // Read more from https://www.php.net/manual/en/pdo.error-handling.php.
    'error' => PDO::ERRMODE_SILENT,

    // [optional]
    // The driver_option for connection.
    // Read more from http://www.php.net/manual/en/pdo.setattribute.php.

    'option' => [
      PDO::ATTR_CASE => PDO::CASE_NATURAL
    ],

    // [optional] Medoo will execute those commands after the database is connected.
    /*
    'command' => [
      'SET SQL_MODE=ANSI_QUOTES'
    ]
    */
  ]);

  require('smsapi.php');

  $orgId = $_SESSION['organisation_id'];

} else {
  echo "{\"status\":\"error\", \"message\":\"Unauthorized\"}";
  exit();
}

function clean($str) {

      // Using str_replace() function
      // to replace the word
      $res = str_replace( array( '\'', '"',
      ',' , ';', '<', '>', '{', '}' ), ' ', $str);

      // Returning the result
      return $res;
      }

function getSimByMSISDN($msisdn) {

$curl = curl_init();
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

$API_NONCE = intval(microtime(true) * 1000);

$API_KEY = "1T775M4EFGP34ETKO6PG";

$API_SECRET = "QEGF7P1AWOGR6P6FS2B4";

//$REQUEST_BODY = '{"iccid": ["423664658624"]}';
$REQUEST_BODY = '';

$API_SIGNATURE = strtoupper(base64_encode(hash_hmac('sha256', $API_KEY . $REQUEST_BODY . $API_NONCE, $API_SECRET, true)));
//echo "API_SIGNATURE: ".$API_SIGNATURE."<br><br><br>";

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://apiv2.datamobile.ag/getSimList',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POST => 1,
  CURLOPT_POSTFIELDS => $REQUEST_BODY,
  CURLOPT_HTTPHEADER => array(
    'API-KEY: '.$API_KEY,
    'API-NONCE: '.$API_NONCE,
    'API-SIGNATURE: '.$API_SIGNATURE,
    'Content-Type: application/json',
    'API-ACTION: getSimList',
  ),
));

$response = curl_exec($curl);

curl_close($curl);

$responseAsArray = json_decode($response, true);
//print_r($responseAsArray);
  for ($i=0;$i < count($responseAsArray);$i++) {
    if (isset($responseAsArray[$i]['MSISDN']) AND $responseAsArray[$i]['MSISDN'] === $msisdn) {
      //echo json_encode($responseAsArray[$i]);
      //echo "getSimByMSISDN returning:";
      //print_r($responseAsArray[$i]);
      return $responseAsArray[$i];
    }
  }
  return false;
}


function getICCIDByMSISDN($msisdn) {

  $curl = curl_init();
  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

  $API_NONCE = intval(microtime(true) * 1000);

  $API_KEY = "1T775M4EFGP34ETKO6PG";

  $API_SECRET = "QEGF7P1AWOGR6P6FS2B4";

  //$REQUEST_BODY = '{"iccid": ["423664658624"]}';
  $REQUEST_BODY = '';

  $API_SIGNATURE = strtoupper(base64_encode(hash_hmac('sha256', $API_KEY . $REQUEST_BODY . $API_NONCE, $API_SECRET, true)));
  //echo "API_SIGNATURE: ".$API_SIGNATURE."<br><br><br>";

  curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://apiv2.datamobile.ag/getSimList',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POST => 1,
    CURLOPT_POSTFIELDS => $REQUEST_BODY,
    CURLOPT_HTTPHEADER => array(
      'API-KEY: '.$API_KEY,
      'API-NONCE: '.$API_NONCE,
      'API-SIGNATURE: '.$API_SIGNATURE,
      'Content-Type: application/json',
      'API-ACTION: getSimList',
    ),
  ));

  $response = curl_exec($curl);

  curl_close($curl);

  $responseAsArray = json_decode($response, true);
  if(is_array($responseAsArray)){
      for ($i=0;$i < count($responseAsArray);$i++) {
        if (isset($responseAsArray[$i]['MSISDN']) AND $responseAsArray[$i]['MSISDN'] === $msisdn) {
          //echo json_encode($responseAsArray[$i]);
          return $responseAsArray[$i]['ICCID'];
        }
      }
    }
    return false;
  }


function getSimByIMEI($imei) {

  $data = $GLOBALS['database']->select("devices", "*",
          [ "imei" => $imei,
            "organisationId" => $orgId ]
        );

  if (count($data) >= 0) {

    $curl = curl_init();
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

    $API_NONCE = intval(microtime(true) * 1000);

    $API_KEY = "1T775M4EFGP34ETKO6PG";

    $API_SECRET = "QEGF7P1AWOGR6P6FS2B4";

    //$REQUEST_BODY = '{"iccid": ["423664658624"]}';
    $REQUEST_BODY = '';

    $API_SIGNATURE = strtoupper(base64_encode(hash_hmac('sha256', $API_KEY . $REQUEST_BODY . $API_NONCE, $API_SECRET, true)));
    //echo "API_SIGNATURE: ".$API_SIGNATURE."<br><br><br>";

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://apiv2.datamobile.ag/getSimList',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POST => 1,
      CURLOPT_POSTFIELDS => $REQUEST_BODY,
      CURLOPT_HTTPHEADER => array(
        'API-KEY: '.$API_KEY,
        'API-NONCE: '.$API_NONCE,
        'API-SIGNATURE: '.$API_SIGNATURE,
        'Content-Type: application/json',
        'API-ACTION: getSimList',
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $responseAsArray = json_decode($response, true);
    //print_r($responseAsArray);
      for ($i=0;$i < count($responseAsArray);$i++) {
        if ($responseAsArray[$i]['MSISDN'] === $data[0]['msisdn']) {
          //echo json_encode($responseAsArray[$i]);
          return $responseAsArray[$i]['ICCID'];
        }
      }
      return false;

      } else {
        return false;
      }

  }

function getSimStateFromICCID($iccid) {

  $curl = curl_init();

  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

  $API_NONCE = intval(microtime(true) * 1000);

  $API_KEY = "1T775M4EFGP34ETKO6PG";

  $API_SECRET = "QEGF7P1AWOGR6P6FS2B4";

  //$REQUEST_BODY = '{"iccid": ["423664658624"]}';

  $REQUEST_BODY = '{ "iccid": ["'.$iccid.'"] }';

  $API_SIGNATURE = strtoupper(base64_encode(hash_hmac('sha256', $API_KEY . $REQUEST_BODY . $API_NONCE, $API_SECRET, true)));
  //echo "API_SIGNATURE: ".$API_SIGNATURE."<br><br><br>";

  curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://apiv2.datamobile.ag/getSIMStatus',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POST => 1,
    CURLOPT_POSTFIELDS => $REQUEST_BODY,
    CURLOPT_HTTPHEADER => array(
      'API-KEY: '.$API_KEY,
      'API-NONCE: '.$API_NONCE,
      'API-SIGNATURE: '.$API_SIGNATURE,
      'Content-Type: application/json',
      'API-ACTION: getSIMStatus',
    ),
  ));

  $info = curl_getinfo($curl);
  $response = curl_exec($curl);
  curl_close($curl);

  $responseAsArray = json_decode($response, true);

  if (isset($responseAsArray[$iccid]) AND $responseAsArray[$iccid] !== "") {
    return intVal($responseAsArray[$iccid]);
  } else {
    return $response;
  }

  }

function setSimStateFromICCID($iccid, $state) {

$curl = curl_init();

curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

$API_NONCE = intval(microtime(true) * 1000);

$API_KEY = "1T775M4EFGP34ETKO6PG";

$API_SECRET = "QEGF7P1AWOGR6P6FS2B4";

//$REQUEST_BODY = '{"iccid": ["423664658624"]}';

$REQUEST_BODY = '{
	"iccid": {
		"'.$iccid.'": {
			"setStatus": '.intval($state).'
		}
	}
}';

$API_SIGNATURE = strtoupper(base64_encode(hash_hmac('sha256', $API_KEY . $REQUEST_BODY . $API_NONCE, $API_SECRET, true)));
//echo "API_SIGNATURE: ".$API_SIGNATURE."<br><br><br>";

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://apiv2.datamobile.ag/setSIMState',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POST => 1,
  CURLOPT_POSTFIELDS => $REQUEST_BODY,
  CURLOPT_HTTPHEADER => array(
    'API-KEY: '.$API_KEY,
    'API-NONCE: '.$API_NONCE,
    'API-SIGNATURE: '.$API_SIGNATURE,
    'Content-Type: application/json',
    'API-ACTION: setSIMState',
  ),
));

$info = curl_getinfo($curl);
$response = curl_exec($curl);
curl_close($curl);

$responseAsArray = json_decode($response, true);

if (isset($responseAsArray[$iccid]) AND $responseAsArray[$iccid] === "success") {
  return true;
} else {
  return $response;
}

}

function didAllSmsTasksSucceed($database, $taskId) {
    $data = $database->select("queueSms", "*",
  [
    "taskId" => $taskId
  ]
  );

  $dataLen = count($data);

  if ($dataLen > 0) {
      //echo "count of subtasks is: ".$dataLen."\n";
      //print_r($data);
      //echo "\n";
      //return false;

  $countSuccessfulSms = 0;
  for($i=0;$i<$dataLen;$i++) {
      //echo "status === ".$data[$i]["status"]."\n";
      if (intVal($data[$i]["status"]) === 2) {
        //echo "successfulCount IS SUCCESSFULL \n";
          $countSuccessfulSms++;
      }
      //echo "successfulCount ===  ".$countSuccessfulSms."\n";
      //return false;
  }

  if ($countSuccessfulSms === count($data)) {
    $updateSms = $database->update("queueAssign", [
        "status" => 1
      ], [ "taskId" => $taskId ]);
      return true;
  } else {
      return false;
  }

} else {
    return false;
}

}

function didOneSmsTaskFail($database, $taskId) {
    $data = $database->select("queueSms", "*",
  [
    "taskId" => $taskId,
    "status" => 500
  ]
  );

  $dataLen = count($data);

  if ($dataLen > 0) {
      //echo "count of subtasks is: ".$dataLen."\n";
      //print_r($data);
      //echo "\n";
      //return false;

      $updateQueue = $database->update("queueAssign", [
          "status" => 500
        ], [ "taskId" => $taskId ]);
        return true;

  } else {
      return false;
  }

}


if (isset($_GET['action']) AND $_GET['action'] === "getMSISDN" AND isset($_GET['imei'])) {
  $imei = $_GET['imei'];
  $data = $database->select("devices", "*",
      [ "imei" => $imei,
        "organisationId" => $orgId ]
    );

  if (count($data) >= 0) {
    $getSIMStatus = getSimStateFromICCID(getICCIDByMSISDN($data[0]['msisdn']));
    if ($getSIMStatus !== false AND intVal($getSIMStatus) >= 0) {
      echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"$getSIMStatus\"}";
    } else {
      echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
    }
  } else {
    echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
  }
}

if (isset($_GET['action']) AND $_GET['action'] === "enableSIM" AND isset($_GET['imei'])) {
    $imei = $_GET['imei'];
    $data = $database->select("devices", "*",
    [ "imei" => $imei,
      "organisationId" => $orgId ]
    );

    if (count($data) >= 0) {
      $configureSIM = setSimStateFromICCID(getICCIDByMSISDN($data[0]['msisdn']), 1);
      if ($configureSIM === true) {
        echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"done\"}";
      } else {
        echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
      }
    } else {
      echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
    }
}

if (isset($_GET['action']) AND $_GET['action'] === "disableSIM" AND isset($_GET['imei'])) {
    $imei = $_GET['imei'];
    $data = $database->select("devices", "*",
      [ "imei" => $imei,
        "organisationId" => $orgId ]
    );

    if (count($data) >= 0) {
      $configureSIM = setSimStateFromICCID(getICCIDByMSISDN($data[0]['msisdn']), 0);
      if ($configureSIM === true) {
        echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"done\"}";
      } else {
        echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
      }
    } else {
      echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
    }
}

if (isset($_GET['action']) AND $_GET['action'] === "returnDevice" AND isset($_GET['imei'])) {
  $imei = $_GET['imei'];
  $data = $database->select("devices", "*",
    [ "imei" => $imei,
      "organisationId" => $orgId ]
  );

  if (count($data) >= 0) {

    $taskId = md5(time());

    $resetSms = sendActionCommandDeviceReset($data[0]['msisdn'], $data[0]['hardwareDeviceType'], $data[0]['imei'], $taskId);
    if (is_array($resetSms["details"]["messages"])) {
        $insertReturnQueue = $database->insert("queueAssign", [
          "type" => "returnDevice",
          "time" => time(),
          "status" => 0,
          "taskId" => $taskId,
          "msisdn" => $data[0]['msisdn'],
          "imei" => $data[0]['imei'],
          "assignParameters" => json_encode([
            "active" => 1
          ])
        ]);
        echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"done\"}";
    } else {
        echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
    }



    /*
    $configureSIM = setSimStateFromICCID(getSimByMSISDN($data[0]['msisdn']), 0);
    if ($configureSIM === true) {
      $returnDevice = $database->update("devices", [
        "active" => 1,
        "homeWifiMac" => "",
        "homeWifiLat" => "",
        "homeWifiLng" => "",
        "homeWifiDescr" => "",
        "homeBeaconMac" => "",
        "homeBeaconLat" => "",
        "homeBeaconLng" => "",
        "homeBeaconDescr" => ""
      ], [ "imei" => $imei ]);
      echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"done\"}";
    } else {
      echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
    }
    */



  } else {
    echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
  }
}

if (isset($_GET['action']) AND $_GET['action'] === "shutdownDevice" AND isset($_GET['imei'])) {
  $imei = $_GET['imei'];
  $data = $database->select("devices", "*",
    [ "imei" => $imei,
      "organisationId" => $orgId ]
  );

  if (count($data) >= 0) {
      $command = sendActionCommandDeviceShutdown($data[0]['msisdn']);
      echo "{\"status\":\"done\", \"response\":\"$command\"}";
  } else {
    echo "{\"msisdn\":\"".$data[0]['msisdn']."\", \"status\":\"error\"}";
  }
}

if (isset($_GET['action']) AND $_GET['action'] === "load" AND isset($_GET['imei']) AND !isset($_POST['umoDeviceIdInput'])) {
    $imei = $_GET['imei'];

    $data = $database->select("devices", "*",
    [ "imei" => $imei,
      "organisationId" => $orgId
    ]
    );

    if (count($data) > 0) {

      $tempGetSim = getSimByMSISDN($data[0]['msisdn']);
      //echo "tempGetSim === ";
      //print_r($tempGetSim);

      if ($tempGetSim !== false AND count($tempGetSim) > 0) {
        $data[0]['simStatus'] = $tempGetSim['SimStatus'];
        $data[0]['simOnlineStatus'] = $tempGetSim['OnlineStatus'];
      } else {
        //echo json_encode(array("error" => "devices not found in SIM DB"));
        //exit();
        //echo "1 tempGetSim === false or count() === 0";
        //print_r($tempGetSim);
      }

      echo json_encode(array("data" => $data));
    } else {
      echo json_encode(array("error" => "devices not found"));
    }
}

if (isset($_GET['action']) AND $_GET['action'] === "loadAll") {

  $data = $database->select("devices", "*",
  [ "organisationId" => $orgId ]
  );

  if (count($data) > 0) {

    $data[0]['simStatus'] = getSimStateFromICCID(getICCIDByMSISDN($data[0]['msisdn']));

    echo json_encode(array("data" => $data));
  } else {
    echo json_encode(array("error" => "devices not found"));
  }
}

if (isset($_GET['action']) AND $_GET['action'] === "saveData" AND isset($_POST['umoDeviceIdInput']) AND isset($_GET['imei'])) {
  if (!empty($_POST['umoDeviceIdInput'])) {
    if (isset($_POST['homeWifiMac']) AND !empty($_POST['homeWifiMac'])) { $homeWifiMac = $_POST['homeWifiMac']; } else { $homeWifiMac = ""; }
    if (isset($_POST['homeWifiLat']) AND !empty($_POST['homeWifiLat'])) { $homeWifiLat = $_POST['homeWifiLat']; } else { $homeWifiLat = ""; }
    if (isset($_POST['homeWifiLng']) AND !empty($_POST['homeWifiLng'])) { $homeWifiLng = $_POST['homeWifiLng']; } else { $homeWifiLng = ""; }
    if (isset($_POST['homeWifiDescr']) AND !empty($_POST['homeWifiDescr'])) { $homeWifiDescr = str_replace(' ','_',$_POST['homeWifiDescr']); } else { $homeWifiDescr = ""; }

    if (isset($_POST['homeBeaconMac']) AND !empty($_POST['homeBeaconMac'])) { $homeBeaconMac = $_POST['homeBeaconMac']; } else { $homeBeaconMac = ""; }
    if (isset($_POST['homeBeaconLat']) AND !empty($_POST['homeBeaconLat'])) { $homeBeaconLat = $_POST['homeBeaconLat']; } else { $homeBeaconLat = ""; }
    if (isset($_POST['homeBeaconLng']) AND !empty($_POST['homeBeaconLng'])) { $homeBeaconLng = $_POST['homeBeaconLng']; } else { $homeBeaconLng = ""; }
    if (isset($_POST['homeBeaconDescr']) AND !empty($_POST['homeBeaconDescr'])) { $homeBeaconDescr = str_replace(' ','_',$_POST['homeBeaconDescr']); } else { $homeBeaconDescr = ""; }

    $organisationId = $orgId;
    $imei = $_GET['imei'];
    $umoDeviceId = $_POST['umoDeviceIdInput'];
    $deviceStatus = "off";
    $translatedSIMStatus = "";
    if (isset($_POST['deviceStatus']) AND !empty($_POST['deviceStatus']) AND $_POST['deviceStatus'] == "on") {
      $deviceStatus = "2";
      $translatedSIMStatus = 1;
    } else {
      $deviceStatus = "1";
      $translatedSIMStatus = 0;
    }

    $assignDevice = $database->update("devices", [
      "umoDeviceId" => $umoDeviceId,
      "homeWifiMac" => $homeWifiMac,
      "homeWifiLat" => $homeWifiLat,
      "homeWifiLng" => $homeWifiLng,
      "homeWifiDescr" => $homeWifiDescr,
      "homeBeaconMac" => $homeBeaconMac,
      "homeBeaconLat" => $homeBeaconLat,
      "homeBeaconLng" => $homeBeaconLng,
      "homeBeaconDescr" => $homeBeaconDescr
    ], [ "imei" => $imei,
      "organisationId" => $orgId ]);

    $data = $database->select("devices", "*",
    [ "imei" => $imei,
      "organisationId" => $orgId ]
    );

    //print_r($assignDevice);

    if (!$assignDevice) {
      echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "error"}';
    } else {
      echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "done"}';
    }

  } else {
      echo "EMPTY UMODEVICEID";
  }

}

if (isset($_GET['action']) AND $_GET['action'] === "saveSubmit" AND isset($_POST['umoDeviceIdInput']) AND isset($_GET['imei'])) {
  if (!empty($_POST['umoDeviceIdInput'])) {

    if (isset($_POST['homeWifiMac']) AND !empty($_POST['homeWifiMac'])) { $homeWifiMac = $_POST['homeWifiMac']; } else { $homeWifiMac = ""; }
    if (isset($_POST['homeWifiLat']) AND !empty($_POST['homeWifiLat'])) { $homeWifiLat = $_POST['homeWifiLat']; } else { $homeWifiLat = ""; }
    if (isset($_POST['homeWifiLng']) AND !empty($_POST['homeWifiLng'])) { $homeWifiLng = $_POST['homeWifiLng']; } else { $homeWifiLng = ""; }
    if (isset($_POST['homeWifiDescr']) AND !empty($_POST['homeWifiDescr'])) { $homeWifiDescr = str_replace(' ','_',$_POST['homeWifiDescr']); } else { $homeWifiDescr = ""; }

    if (isset($_POST['homeBeaconMac']) AND !empty($_POST['homeBeaconMac'])) { $homeBeaconMac = $_POST['homeBeaconMac']; } else { $homeBeaconMac = ""; }
    if (isset($_POST['homeBeaconLat']) AND !empty($_POST['homeBeaconLat'])) { $homeBeaconLat = $_POST['homeBeaconLat']; } else { $homeBeaconLat = ""; }
    if (isset($_POST['homeBeaconLng']) AND !empty($_POST['homeBeaconLng'])) { $homeBeaconLng = $_POST['homeBeaconLng']; } else { $homeBeaconLng = ""; }
    if (isset($_POST['homeBeaconDescr']) AND !empty($_POST['homeBeaconDescr'])) { $homeBeaconDescr = str_replace(' ','_',$_POST['homeBeaconDescr']); } else { $homeBeaconDescr = ""; }

    $organisationId = $orgId;
    $imei = $_GET['imei'];
    $umoDeviceId = $_POST['umoDeviceIdInput'];
    $deviceStatus = "2";
    $translatedSIMStatus = 1;

    $assignDevice = $database->update("devices", [
      "active" => $deviceStatus,
      "umoDeviceId" => $umoDeviceId,
      "homeWifiMac" => $homeWifiMac,
      "homeWifiLat" => $homeWifiLat,
      "homeWifiLng" => $homeWifiLng,
      "homeWifiDescr" => $homeWifiDescr,
      "homeBeaconMac" => $homeBeaconMac,
      "homeBeaconLat" => $homeBeaconLat,
      "homeBeaconLng" => $homeBeaconLng,
      "homeBeaconDescr" => $homeBeaconDescr
    ], [ "imei" => $imei,
      "organisationId" => $orgId ]);

    $taskId = md5(time());

    $data = $database->select("devices", "*",
    [ "imei" => $imei,
      "organisationId" => $orgId ]
    );

    $insertAssignQueue = $database->insert("queueAssign", [
      "type" => "transmitConfig",
      "time" => time(),
      "status" => 0,
      "taskId" => $taskId,
      "msisdn" => $data[0]['msisdn'],
      "imei" => $data[0]['imei'],
      "assignParameters" => json_encode([
        "active" => $deviceStatus,
        "umoDeviceId" => $umoDeviceId,
        "homeWifiMac" => $homeWifiMac,
        "homeWifiLat" => $homeWifiLat,
        "homeWifiLng" => $homeWifiLng,
        "homeWifiDescr" => $homeWifiDescr,
        "homeBeaconMac" => $homeBeaconMac,
        "homeBeaconLat" => $homeBeaconLat,
        "homeBeaconLng" => $homeBeaconLng,
        "homeBeaconDescr" => $homeBeaconDescr
      ])
    ]);

    //print_r($assignDevice);

    if (!$assignDevice) {
      echo "{\"status\":\"error\"}";
    } else {



      $configureSIM = setSimStateFromICCID(getICCIDByMSISDN($data[0]['msisdn']), $translatedSIMStatus);
      if ($configureSIM === true) {
        echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "done", "desiredSIMState": '.$translatedSIMStatus.', "simUpdateStatus": "done"}';
      } else {
        $errorMsg = clean($configureSIM);
        echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "done", "desiredSIMState": '.$translatedSIMStatus.', "simUpdateStatus": "error", "simUpdateError": "'.$errorMsg.'"}';
      }
      if (!empty($_POST['homeWifiMac']) AND !empty($_POST['homeWifiLat']) AND !empty($_POST['homeWifiLng']) AND !empty($_POST['homeWifiDescr'])) {
        sendConfigCommandHomeWifiSet($data[0]['msisdn'], $data[0]['homeWifiMac'], $data[0]['homeWifiLat'], $data[0]['homeWifiLng'], $data[0]['homeWifiDescr'],$imei,$taskId);
      }
      if (!empty($_POST['homeBeaconMac']) AND !empty($_POST['homeBeaconLat']) AND !empty($_POST['homeBeaconLng']) AND !empty($_POST['homeBeaconDescr'])) {
        sendConfigCommandHomeBeaconSet($data[0]['msisdn'], $data[0]['homeBeaconMac'], $data[0]['homeBeaconLat'], $data[0]['homeBeaconLng'], $data[0]['homeBeaconDescr'],$imei,$taskId);
      }

      sendConfigCommandServerIP($data[0]['msisdn'], $data[0]['imei'], $taskId);

      $orgData = $database->select("organisations", "*",
      [ "id" => $orgId ]
      );

      if (count($orgData)) {
        if (isset($orgData[0]['emergencyNumberPhone']) AND !empty($orgData[0]['emergencyNumberPhone'])) {
          sendConfigCommandEmergencyNumberPhoneOnly($data[0]['msisdn'], $orgData[0]['emergencyNumberPhone'],$imei,$taskId);
          //echo "phone found";
        }
        if (isset($orgData[0]['emergencyNumberSMS']) AND !empty($orgData[0]['emergencyNumberSMS'])) {
          sendConfigCommandEmergencyNumberSMSOnly($data[0]['msisdn'], $orgData[0]['emergencyNumberSMS'],$imei,$taskId);
          //echo "SMS found";
        }
      } else {
        //echo "org not found";

      }
    }

  } else {
      //echo "EMPTY UMODEVICEID";
  }

/*
  $data = $database->update("devices", [
    "organisationId" => $orgId,
    "active" => 2,
    "umoDeviceId" => $umoDeviceId
  ], [ "imei" => $imei ]);

  if ($data->rowCount() > 0) {
    echo "{\"status\":\"done\"}";
  } else {
    echo "{\"status\":\"done\"}";
  }
  */

}

if (isset($_GET['action']) AND $_GET['action'] === "baseStationTransmit" AND isset($_GET['imei'])) {
   if (isset($_POST['baseStationLat']) AND !empty($_POST['baseStationLat']) AND isset($_POST['baseStationLng']) AND !empty($_POST['baseStationLng'])) {
    $organisationId = $orgId;
    $imei = $_GET['imei'];

    $assignDevice = $database->update("devices", [
      "baseStationLat" => $_POST['baseStationLat'],
      "baseStationLng" => $_POST['baseStationLng']
    ], [ "imei" => $imei,
      "organisationId" => $orgId ]);

    $taskId = md5(time());

    $data = $database->select("devices", "*",
    [ "imei" => $imei,
      "organisationId" => $orgId ]
    );

    $sendBaseStationCmd = sendConfigCommandBaseStationSet($data[0]['msisdn'], $_POST['baseStationLat'], $_POST['baseStationLng'], $data[0]['imei'], $taskId);
    if (is_array($sendBaseStationCmd["ids"])) {
      $insertAssignQueue = $database->insert("queueAssign", [
        "type" => "baseStationTransmit",
        "time" => time(),
        "status" => 0,
        "taskId" => $taskId,
        "msisdn" => $data[0]['msisdn'],
        "imei" => $data[0]['imei'],
        "assignParameters" => json_encode([
          "baseStationLat" => $_POST['baseStationLat'],
          "baseStationLng" => $_POST['baseStationLng']
        ])
      ]);
      echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "done", "taskId": "'.$taskId.'", "hardwareDeviceType": "'.$data[0]['hardwareDeviceType'].'"}';
    } else {
      echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "error", "taskId": "'.$taskId.'", "hardwareDeviceType": "'.$data[0]['hardwareDeviceType'].'"}';
    }

    } else {
      echo json_encode(array("error" => "not all parameters set!"));
    }

/*
  $data = $database->update("devices", [
    "organisationId" => $orgId,
    "active" => 2,
    "umoDeviceId" => $umoDeviceId
  ], [ "imei" => $imei ]);

  if ($data->rowCount() > 0) {
    echo "{\"status\":\"done\"}";
  } else {
    echo "{\"status\":\"done\"}";
  }
  */

}

if (isset($_GET['action']) AND $_GET['action'] === "baseStationTransmitStatus" AND isset($_GET['taskId'])) {
    $data = $database->select("queueAssign", "*",
    [ "taskId" => $_GET['taskId'] ]
    );

    if (count($data) > 0 AND didAllSmsTasksSucceed($database,$_GET['taskId'])) {

      $device = $database->select("devices", "*",
      [ "imei" => $data[0]['imei'] ]
      );

      if (count($device) == 1) {
        $updateTask = $database->update("queueAssign", [
          "status" => 1
        ], [ "taskId" => $_GET['taskId'] ]);

        if (!empty($device[0]['hardwareDeviceType']) AND $device[0]['hardwareDeviceType'] == "EV07") {
          echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "done", "taskId": "'.$_GET['taskId'].'", "messageColor": "green", "message": "Jetzt BStation bestät.!", "hardwareDeviceType": "'.$device[0]['hardwareDeviceType'].'"}';
        } else {
          echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "done", "taskId": "'.$_GET['taskId'].'", "hardwareDeviceType": "'.$device[0]['hardwareDeviceType'].'"}';
        }
      }
    } else {
      if (didOneSmsTaskFail($database, $_GET['taskId'])) {
        echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "error", "taskId": "'.$_GET['taskId'].'"}';
      } else {
        echo '{"msisdn": "'.$data[0]['msisdn'].'", "status": "undone", "taskId": "'.$_GET['taskId'].'"}';
      }
    }

}

?>
