<?php

define('TITLE', "Login");
include '../assets/layouts/header.php';
check_logged_out();

?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title>Login - Brand</title>
    <link rel="stylesheet" href="/admin/bs_assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i&amp;display=swap">
    <link rel="stylesheet" href="/admin/bs_assets/fonts/fontawesome-all.min.css">
</head>

<body class="bg-gradient-primary">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-9 col-lg-12 col-xl-10">
                <div class="card shadow-lg o-hidden border-0 my-5">
                    <div class="card-body p-0">
                        <div class="row">
                            <div class="col-lg-6 d-none d-lg-flex">
                                <div id="particles-js" style="background: transparent;width:100%;height:100%;" class="flex-grow-1 bg-login-image particles-js" style="background-image: url(&quot;assets/img/dogs/image3.jpeg&quot;);"></div>
                            </div>
                            <div class="col-lg-6">
                                <div class="p-5">
                                    <div class="text-center">
                                        <h4 class="text-dark mb-4">Herzlich Willkommen!</h4>
                                    </div>
                                    <!-- form -->
                                    <?php if (isset($_GET['selector']) && isset($_GET['validator'])) { ?>

<form class="form-auth" action="includes/reset.inc.php" method="post">

    <?php
        insert_csrf_token();

        $selector = $_GET['selector'];
        $validator = $_GET['validator'];
    ?>

    <input type="hidden" name="selector" value="<?php echo $selector; ?>">
    <input type="hidden" name="validator" value="<?php echo $validator; ?>">

    <div class="text-center">
    </div>

    <h6 class="h5 mb-3 font-weight-normal text-muted text-center">Neues Passwort setzen</h6>

    <div class="text-center mb-3">
        <small class="text-success font-weight-bold">
            <?php
                if (isset($_SESSION['STATUS']['resetsubmit']))
                    echo $_SESSION['STATUS']['resetsubmit'];

            ?>
        </small>
    </div>

    <div class="text-center mb-3">
        <sub class="text-danger">
            <?php
                if (isset($_SESSION['ERRORS']['passworderror']))
                    echo $_SESSION['ERRORS']['passworderror'];
            ?>
        </sub>
    </div>

    <div class=" form-group">
        <input type="password" id="newpassword" name="newpassword" class="form-control" placeholder="Neues Passwort" autocomplete="new-password">
    </div>

    <div class=" form-group mb-5">
        <input type="password" id="confirmpassword" name="confirmpassword" class="form-control" placeholder="Neues Passwort bestätigen" autocomplete="new-password">
    </div>

    <button class="btn btn-lg btn-primary btn-block mb-5 mt-4" type="submit" value="resetsubmit" name="resetsubmit">
        Passwort aktualisieren
    </button>

    <p class="mt-4 mb-3 text-muted text-center">
        <a href="https://solution4care.eu" target="_blank">
            Solution4Care
        </a>
    </p>

</form>

<?php } else { ?>

<form class="form-auth" action="includes/sendtoken.inc.php" method="post">

    <?php insert_csrf_token(); ?>

    <div class="text-center">
    <br><br><br><br><br><br><br><br>                   
    </div>

    <h6 class="h5 mb-3 font-weight-normal text-muted text-center">Passwort zurücksetzen</h6>

    <div class="text-center mb-3">
        <small class="text-success font-weight-bold">
            <?php
                if (isset($_SESSION['STATUS']['resentsend']))
                    echo $_SESSION['STATUS']['resentsend'];

            ?>
        </small>
    </div>

    <div class="form-group">
        <label for="email" class="sr-only">E-Mail</label>
        <input type="email" id="email" name="email" class="form-control" placeholder="Email" required autofocus>
        <sub class="text-danger">
            <?php
                if (isset($_SESSION['ERRORS']['emailerror']))
                    echo $_SESSION['ERRORS']['emailerror'];
            ?>
        </sub>
    </div>

    <button class="btn btn-lg btn-primary btn-block mb-5 mt-4" type="submit" value="resentsend" name="resentsend">
        Link für Reset zukommen lassen
    </button>

    <p class="mt-4 mb-3 text-muted text-center">
        <a href="https://solution4care.eu" target="_blank">
            Solution4Care
        </a>
    </p>

</form>

<?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="/admin/bs_assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="/admin/bs_assets/js/bs-init.js"></script>
    <script src="/admin/bs_assets/js/theme.js"></script>
    <script src="//cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
particlesJS("particles-js", {"particles":{"number":{"value":80,"density":{"enable":true,"value_area":800}},"color":{"value":"#4b71dd"},"shape":{"type":"circle","stroke":{"width":0,"color":"#000000"},"polygon":{"nb_sides":5},"image":{"src":"img/github.svg","width":100,"height":100}},"opacity":{"value":0.5,"random":false,"anim":{"enable":false,"speed":1,"opacity_min":0.1,"sync":false}},"size":{"value":3,"random":true,"anim":{"enable":false,"speed":40,"size_min":0.1,"sync":false}},"line_linked":{"enable":true,"distance":150,"color":"#c3c3c3","opacity":0.4,"width":1},"move":{"enable":true,"speed":6,"direction":"none","random":false,"straight":false,"out_mode":"out","bounce":false,"attract":{"enable":false,"rotateX":600,"rotateY":1200}}},"interactivity":{"detect_on":"canvas","events":{"onhover":{"enable":true,"mode":"repulse"},"onclick":{"enable":true,"mode":"push"},"resize":true},"modes":{"grab":{"distance":400,"line_linked":{"opacity":1}},"bubble":{"distance":400,"size":40,"duration":2,"opacity":8,"speed":3},"repulse":{"distance":200,"duration":0.4},"push":{"particles_nb":4},"remove":{"particles_nb":2}}},"retina_detect":true});var count_particles, stats, update; stats = new Stats; stats.setMode(0); stats.domElement.style.position = 'absolute'; stats.domElement.style.left = '0px'; stats.domElement.style.top = '0px'; document.body.appendChild(stats.domElement); count_particles = document.querySelector('.js-count-particles'); update = function() { stats.begin(); stats.end(); if (window.pJSDom[0].pJS.particles && window.pJSDom[0].pJS.particles.array) { count_particles.innerText = window.pJSDom[0].pJS.particles.array.length; } requestAnimationFrame(update); }; requestAnimationFrame(update);;    </script>
</body>

