<?php

require('Medoo.php');

include '/var/www/html/admin/assets/layouts/header.php';

use \Medoo\Medoo;

function generateDropdownHTML($items, $orgId) {
  $html = '<div class="dropdown" style="text-align: right;">' .
    '<button id="mandantenButton" class="btn btn-primary dropdown-toggle fs-6 text-center show" aria-expanded="true" data-bs-toggle="dropdown" type="button" style="width: 100%;"> ALLE ORGANISATIONEN</button>' .
    '<div id="mandantenDropdown" class="dropdown-menu" style="width: 100%; position: absolute; inset: 0px auto auto 0px; margin: 0px; transform: translate3d(0px, 40px, 0px);" data-popper-placement="bottom-start">' .
    '<a data-orgid="'.$orgId.'" class="dropdown-item" href="#" style="font-size: 1.1rem;width: 100%;border-bottom: 1px solid rgb(227,230,240);color: rgb(133,135,150);">LAGER</a>'.
    '<a data-orgid="all" class="dropdown-item" href="#" style="font-size: 1.1rem;width: 100%;border-bottom: 1px solid rgb(227,230,240);color: rgb(133,135,150);">ALLE ORGANISATIONEN</a>';

  foreach ($items as $item) {
    $html .= '<a data-orgid="' . $item['id'] . '" class="dropdown-item" href="#" style="font-size: 1.1rem;width: 100%;border-bottom: 1px solid rgb(227,230,240);color: rgb(133,135,150);">' . $item['name'] . '</a>';
  }

  $html .= '</div></div>';

  echo $html;
  }

if(check_logged_in()) {

$orgId = $_SESSION['organisation_id'];
} else {
  exit();
}

$database = new \Medoo\Medoo([
	// [required]
  'type' => 'mysql',
	'host' => 'localhost',
	'database' => 'gpsTest',
	'username' => 'gpsTest',
	'password' => '6HNV*=?U',

	// [optional]
	'charset' => 'utf8mb4',
	'collation' => 'utf8mb4_general_ci',
	'port' => 3306,

	// [optional] The table prefix. All table names will be prefixed as PREFIX_table.
//	'prefix' => 'PREFIX_',

	// [optional] To enable logging. It is disabled by default for better performance.
	//'logging' => true,

	// [optional]
	// Error mode
	// Error handling strategies when the error has occurred.
	// PDO::ERRMODE_SILENT (default) | PDO::ERRMODE_WARNING | PDO::ERRMODE_EXCEPTION
	// Read more from https://www.php.net/manual/en/pdo.error-handling.php.
	'error' => PDO::ERRMODE_EXCEPTION,

	// [optional]
	// The driver_option for connection.
	// Read more from http://www.php.net/manual/en/pdo.setattribute.php.

  'option' => [
		PDO::ATTR_CASE => PDO::CASE_NATURAL
	],

	// [optional] Medoo will execute those commands after the database is connected.
  /*
  'command' => [
		'SET SQL_MODE=ANSI_QUOTES'
	]
  */
]);

$data = $database->select("organisations", "*",
[ "parentOrganisationId" => $orgId ]
);

if (is_array($data) AND count($data) > 0) {

} else {
  $data = array();

}

$perm_field_umoDeviceId = true;
$perm_button_saveConfig = true;
$perm_button_saveSubmitConfig = true;
$perm_button_simConfig = true;
$perm_button_shutdown = true;
$perm_button_returnDevice = true;
$perm_button_multipleHomeWifi = true;
$perm_button_homeWifiDelete = true;
$perm_button_homeWifiUpdate = true;

/*
if($thisOrgData['perm_field_umoDeviceId'] == 1) { $perm_field_umoDeviceId = true; }
if($thisOrgData['perm_button_saveConfig'] == 1) { $perm_button_saveConfig = true; }
if($thisOrgData['perm_button_saveSubmitConfig'] == 1) { $perm_button_saveSubmitConfig = true; }
if($thisOrgData['perm_button_simConfig'] == 1) { $perm_button_simConfig = true; }
if($thisOrgData['perm_button_shutdown'] == 1) { $perm_button_shutdown = true; }
if($thisOrgData['perm_button_returnDevice'] == 1) { $perm_button_returnDevice = true; }
if($thisOrgData['perm_button_multipleHomeWifi'] == 1) { $perm_button_multipleHomeWifi = true; }
if($thisOrgData['perm_button_homeWifiDelete'] == 1) { $perm_button_homeWifiDelete = true; }
if($thisOrgData['perm_button_homeWifiUpdate'] == 1) { $perm_button_homeWifiUpdate = true; }
*/

?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title>Table - Brand</title>
    <link rel="stylesheet" href="bs_assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i&amp;display=swap">
    <link rel="stylesheet" href="bs_assets/fonts/fontawesome-all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <link rel="stylesheet" href="assets/js/formvalidation/css/formValidation.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://unpkg.com/tachyons@4.10.0/css/tachyons.min.css">
    <style>
      
      .fv-plugins-icon {
        margin-top: -10px !important;
      }

      .homeWifiInstance {
        border-bottom: 1px solid lightgray; 
      }

      .status-2 {
            background-color: lightgreen;
        }
        .status-3 {
            background-color: lightcoral; /* Note: 'lightred' is not a valid color. Use a valid color code or name, like 'lightcoral'. */
        }

        #taskTableContainer {
          margin-top:3em;
          position:relative;
          //bottom:0px;
          width:100%;
          height:18vh;
          padding:1em;
          background-color: white;
          z-index:9999;
          overflow:scroll;
          font-size: .8em;
          color:black;
        }

        .blink{
          animation: blink 2s infinite;
        }
        .blink2{
          animation: blink 5s infinite;
        }
        @keyframes blink{
          0% {
            background: orange;
          }
          60% {
            background: transparent;
          }
          100% {
            background: orange;
          }
        }

        @-webkit-keyframes blink{
          0% {
            background: orange;
          }
          60% {
            background: transparent;
          }
          100% {
            background: orange;
          }
        }

        @keyframes blink2{
          0% {
            background: gray;
          }
          60% {
            background: transparent;
          }
          100% {
            background: gray;
          }
        }

        @-webkit-keyframes blink2{
          0% {
            background: gray;
          }
          60% {
            background: transparent;
          }
          100% {
            background: gray;
          }
        }

        .sticky-header {
          position: sticky !important;
          top: -13px;
          background: white;
          z-index: 2;
          height: 2em !important;
        }


    </style>
</head>

<body id="page-top">
    <div id="wrapper">
        <nav class="navbar navbar-dark align-items-start sidebar sidebar-dark accordion bg-gradient-primary p-0">
            <div class="container-fluid d-flex flex-column p-0"><a class="navbar-brand d-flex justify-content-center align-items-center sidebar-brand m-0" href="#">
                    <div class="sidebar-brand-icon rotate-n-15"></div>
                    <div class="sidebar-brand-text mx-3"><span>SOLUTION4CARE</span></div>
                </a>
                <hr class="sidebar-divider my-0">
                <ul class="navbar-nav text-light" id="accordionSidebar">
                <li class="nav-item"><a class="nav-link" href="orgAdminOverview.php"><i class="fas fa-tachometer-alt"></i><span>Geräteübersicht</span></a></li>
                <li class="nav-item"><a class="nav-link" href="orgAdminStatus.php"><i class="fas fa-tachometer-alt"></i><span>Gerätestatus</span></a></li>
                  <li class="nav-item"><a class="nav-link" href="orgAdminAssign.php"><i class="fas fa-plus-circle"></i><span>Geräte zuweisen</span></a></li>
                  <li class="nav-item"><a class="nav-link" href="orgAdminZuweisung.php"><i class="fas fa-plus-circle"></i><span>Geräte programmieren</span></a></li>
                    <li class="nav-item"></li>
                </ul>
                <div class="text-center d-none d-md-inline"><button class="btn rounded-circle border-0" id="sidebarToggle" type="button"></button></div>
            </div>
        <a href="changelog.php" style="position:absolute;margin-top:600px;width:100%;text-align:center;color:white;text-decoration:none;font-size:0.7em;">CHANGELOG</a>
        </nav>
        <div class="d-flex flex-column" id="content-wrapper">
            <div id="content" style="width: 100%;">
                <nav class="navbar navbar-light navbar-expand bg-white shadow mb-4 topbar static-top">
                    <div class="container-fluid"><button class="btn btn-link d-md-none rounded-circle me-3" id="sidebarToggleTop" type="button"><i class="fas fa-bars"></i></button><span class="fw-bold d-none d-lg-inline me-2 text-gray-600 small">ORGADMIN CONSOLE</span>
                        <ul class="navbar-nav flex-nowrap ms-auto">
                            <li class="nav-item dropdown d-sm-none no-arrow"><a class="dropdown-toggle nav-link" aria-expanded="false" data-bs-toggle="dropdown" href="#"><i class="fas fa-search"></i></a>
                                <div class="dropdown-menu dropdown-menu-end p-3 animated--grow-in" aria-labelledby="searchDropdown">
                                    <form class="me-auto navbar-search w-100">
                                        <div class="input-group"><input class="bg-light form-control border-0 small" type="text" placeholder="Search for ...">
                                            <div class="input-group-append"><button class="btn btn-primary py-0" type="button"><i class="fas fa-search"></i></button></div>
                                        </div>
                                    </form>
                                </div>
                            </li>
                            <li class="nav-item dropdown no-arrow mx-1"></li>
                            <li class="nav-item dropdown no-arrow mx-1">
                                <div class="shadow dropdown-list dropdown-menu dropdown-menu-end" aria-labelledby="alertsDropdown"></div>
                            </li>
                            <div class="d-none d-sm-block topbar-divider"></div>
                            <li class="nav-item dropdown no-arrow">
                                <div class="nav-item dropdown no-arrow"><a class="dropdown-toggle nav-link" aria-expanded="false" data-bs-toggle="dropdown" href="#"><img class="border rounded-circle img-profile" src="./assets/uploads/users/<?php if (isset($_SESSION['profile_image']) AND !empty($_SESSION['profile_image'])) { echo $_SESSION['profile_image']; } else { echo "_defaultUser.png"; }?>"></a>
                                    <div class="dropdown-menu shadow dropdown-menu-end animated--grow-in"><a class="dropdown-item" href="./profile-edit/"><i class="fas fa-cogs fa-sm fa-fw me-2 text-gray-400"></i>&nbsp;Mein Account <?php if (isset($_SESSION['username']) AND !empty($_SESSION['username'])) { echo "(".$_SESSION['username'].")"; }?></a>
                                        <div class="dropdown-divider"></div><a class="dropdown-item" href="./logout/"><i class="fas fa-sign-out-alt fa-sm fa-fw me-2 text-gray-400"></i>&nbsp;Abmelden</a>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </nav>
                <div class="container-fluid">
                  <!-- Modal -->
                <div class="modal" id="returnModal" tabindex="-1" role="dialog" aria-labelledby="returnModalLabel" aria-hidden="true">
                  <div class="modal-dialog" role="document">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Gerätezuweisung entfernen</h5>
                        <button type="button" class="close closeReturnModal" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body">
                        Sind Sie sicher, dass Sie die Zuweisung des Gerätes unwiderruflich entfernen möchten?<br><br>
                        <b>Das Gerät wird nach dem Reset automatisch ausgeschalten dh. Sie müssen das Gerät nicht gesondert ausschalten.</b><br><br>
                        Der gesamte Vorgang kann bis zu mehrere Minuten dauern.
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary closeReturnModal" data-dismiss="modal">Abbrechen</button>
                        <button type="button" id="confirmReturnModal" class="btn btn-danger">Gerätezuweisung entfernen</button>
                      </div>
                    </div> 
                  </div>
                </div>
                <div class="modal" id="deleteHomeWifiModal" tabindex="-1" role="dialog" aria-labelledby="deleteHomeWifiModal" aria-hidden="true">
                  <div class="modal-dialog" role="document">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">HomeWifi Daten löschen</h5>
                        <button type="button" class="close closeDeleteHomeWifiModal" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body">
                        Sind Sie sicher, dass Sie ALLE HomeWifi Daten Ihres Gerätes unwiderruflich entfernen möchten?<br><br>
                        Um das Ger&auml;t auf <strong>Werkseinstellungen</strong> zur&uuml;ckzusetzen verwenden Sie bitte die Schaltfl&auml;che <strong>&quot;Vom Kunden retour&quot;</strong>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary closeDeleteHomeWifiModal" data-dismiss="modal">Abbrechen</button>
                        <button type="button" id="confirmDeleteHomeWifiModal" class="btn btn-danger">HomeWifi Daten entfernen</button>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="modal" id="shutdownModal" tabindex="-1" role="dialog" aria-labelledby="returnModalLabel" aria-hidden="true">
                  <div class="modal-dialog" role="document">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Gerät ausschalten</h5>
                        <button type="button" class="close closeShutdownModal" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body">
                        Sind Sie sicher, dass Sie das Gerät ausschalten bzw. herunterfahren möchten?
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary closeShutdownModal" data-dismiss="modal">Abbrechen</button>
                        <button type="button" id="confirmShutdownModal" class="btn btn-danger">Gerät ausschalten</button>
                      </div>
                    </div>
                  </div>
                </div>
                    <h5 class="text-dark mb-4">Gerätekonfiguration</h5>
                    <div class="card shadow">
                    <?php include 'changelogWidget.php'; ?>
                        <div class="card-header py-3">
                            <div class="row">
                                <!-- <div clas="col">
                                        <?php //generateDropdownHTML($data, $orgId) ?>
                                    </div>
                                    <br><br> -->
                                <div class="col"><!-- small class="form-text">IMEI eingeben / scannen:</small --><input id="imeiScanInput" name="imeiScanInput" style="width: 100%;" placeholder="...Scannen Sie hier die IMEI oder verwenden Sie Copy & Paste..." value=""></div>

                            </div>
                        </div>
                        <div class="card-body" style="min-height: 66vh;">
                            <div class="row">
                                <div class="col">
                                  <form id="assignmentForm" action="" method="post">
                                    <div class="row" style="margin-bottom: 0px;">
                                        <div class="col">
                                            <h4 style="font-size: 1rem;">Gerät</h4>
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;">
                                        <div class="col" style="margin-bottom: 4px;">
                                            <h5 style="margin-bottom: 0px;font-size: .8rem;">IMEI</h5><input id="imeiInput" name="imeiInput" type="text" style="width: 100%;background: rgb(242,242,242);font-size: .8rem;border-radius: 3px;border-width: 1px;" readonly disabled value="" placeholder="">
                                        </div>
                                    </div>
                                    
                                    <div class="row" style="font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;">UMO Geräte-ID</h5><input id="umoDeviceId" name="umoDeviceId" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" readonly disabled>
                                        </div>
                                    </div>
                                   
                                    <div class="row" style="margin-bottom: 0px;font-size: .8rem;">

                                        <div class="col" style="font-size: .8rem;">
                                            <div class="row" style="font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">Gerätetyp</h5><input id="hardwareDeviceTypeInput" name="hardwareDeviceTypeInput" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" readonly disabled>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">Status</h5><input id="deviceStatusInput" name="deviceStatusInput" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" placeholder="" readonly disabled>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">SIM-Status</h5><input id="simStatusInput" name="simStatusInput" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" placeholder="" readonly disabled>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">SIM Online-Status</h5><input id="simOnlineStatusInput" name="simOnlineStatusInput" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" placeholder="" readonly disabled>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                                <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;">Telefonnummer</h5><input id="msisdnInput" name="msisdnInput" type="text" style="width: 100%;background: rgb(242,242,242);margin-bottom: 4px;font-size: .8rem;border-radius: 3px;border-width: 1px;" placeholder="" readonly disabled>
                                                </div>
                                            </div>
                                        </div>
                                    </div>



                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <div class="row">
                                                <div class="col fl">
                                                    <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">UMO Geräte-ID:</h5><input id="umoDeviceIdInput" name="umoDeviceIdInput" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="0123456789" value="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                  <div class="homeWifiInstancesContainer">
                                    <div class="homeWifiInstance" id="homeWifiInstance1" style="background:rgba(0,0,0,.05);">
                                        <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                          <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                            <div class="row">
                                              <div class="col fl fv-plugins-icon-container">
                                                <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI <b>#1</b> <br>
                                                  <b>Router MAC-Adresse:</b>
                                                </h5>
                                                <input class="homeWifiMac" id="homeWifiMac1" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." name="homeWifiMac1" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac1" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container">
                                                <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI <br>
                                                  <b>Beschreibung des Orts:</b>
                                                </h5>
                                                <input id="homeWifiDescr1" name="homeWifiDescr1" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr1" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                          <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI <br>
                                              <b>Koordinate LAT:</b>
                                            </h5>
                                            <input id="homeWifiLat1" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." name="homeWifiLat1" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat1" class="fv-plugins-icon"></i>
                                          <div class="fv-plugins-message-container"></div></div>
                                          <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI <br>
                                              <b>Koordinate LNG:</b>
                                            </h5>
                                            <input id="homeWifiLng1" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-9]{1,2}|1[0-7][0-9]|180)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." name="homeWifiLng1" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng1" class="fv-plugins-icon"></i>
                                          <div class="fv-plugins-message-container"></div></div>
                                        </div>
                                        <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                          <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                            <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                          </div>
                                          <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;"><input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></div>
                                        </div>
                                      </div>
                                      
                                        <div class="homeWifiInstance" id="homeWifiInstance2" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>2</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac2" name="homeWifiMac2" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac2" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr2" name="homeWifiDescr2" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr2" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates2">
                                                  <label for="copyCoordinates2" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat2" name="homeWifiLat2" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat2" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng2" name="homeWifiLng2" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng2" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                          </div>
                                      </div>
                                    
                                        <div class="homeWifiInstance" id="homeWifiInstance3" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>3</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac3" name="homeWifiMac3" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac3" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr3" name="homeWifiDescr3" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr3" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates3">
                                                  <label for="copyCoordinates3" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat3" name="homeWifiLat3" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat3" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng3" name="homeWifiLng3" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng3" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                          </div>
                                      </div>
                                    
                                        <div class="homeWifiInstance" id="homeWifiInstance4" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>4</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac4" name="homeWifiMac4" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac4" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr4" name="homeWifiDescr4" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr4" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates4">
                                                  <label for="copyCoordinates4" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat4" name="homeWifiLat4" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat4" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng4" name="homeWifiLng4" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng4" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                          </div>
                                      </div>
                                    
                                        <div class="homeWifiInstance" id="homeWifiInstance5" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>5</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac5" name="homeWifiMac5" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac5" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr5" name="homeWifiDescr5" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr5" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates5">
                                                  <label for="copyCoordinates5" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat5" name="homeWifiLat5" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat5" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng5" name="homeWifiLng5" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng5" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                          </div>
                                      </div>
                                    
                                        <div class="homeWifiInstance" id="homeWifiInstance6" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>6</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac6" name="homeWifiMac6" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac6" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr6" name="homeWifiDescr6" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr6" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates6">
                                                  <label for="copyCoordinates6" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat6" name="homeWifiLat6" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat6" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng6" name="homeWifiLng6" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng6" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                          </div>
                                      </div>
                                    
                                        <div class="homeWifiInstance" id="homeWifiInstance7" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>7</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac7" name="homeWifiMac7" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac7" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr7" name="homeWifiDescr7" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr7" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates7">
                                                  <label for="copyCoordinates7" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat7" name="homeWifiLat7" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat7" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng7" name="homeWifiLng7" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng7" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                          </div>
                                      </div>
                                    
                                        <div class="homeWifiInstance" id="homeWifiInstance8" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>8</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac8" name="homeWifiMac8" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac8" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr8" name="homeWifiDescr8" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr8" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates8">
                                                  <label for="copyCoordinates8" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat8" name="homeWifiLat8" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat8" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng8" name="homeWifiLng8" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng8" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                          </div>
                                      </div>
                                    
                                        <div class="homeWifiInstance" id="homeWifiInstance9" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>9</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac9" name="homeWifiMac9" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac9" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr9" name="homeWifiDescr9" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr9" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates9">
                                                  <label for="copyCoordinates9" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat9" name="homeWifiLat9" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat9" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng9" name="homeWifiLng9" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng9" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen">
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                          </div>
                                      </div>
                                    
                                        <div class="homeWifiInstance" id="homeWifiInstance10" style="background:rgba(0,0,0,.05);padding-top:10px;display:none;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <div class="row">
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI #<b>10</b><br><b>Router MAC-Adresse:</b></h5>
                                                          <input class="homeWifiMac" id="homeWifiMac10" name="homeWifiMac10" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""><i data-field="homeWifiMac10" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                      <div class="col fl fv-plugins-icon-container">
                                                          <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Beschreibung des Orts:</b></h5>
                                                          <input id="homeWifiDescr10" name="homeWifiDescr10" data-fv-not-empty="true" data-fv-not-empty___message="Bitte HomeWifi Beschreibung eingeben!" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16"><i data-field="homeWifiDescr10" class="fv-plugins-icon"></i>
                                                      <div class="fv-plugins-message-container"></div></div>
                                                  </div>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px; font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px; font-size: .8rem;">
                                                  <input type="checkbox" class="copy-coordinates" id="copyCoordinates10">
                                                  <label for="copyCoordinates10" class="copy-coordinates-label">Koordinaten von erster HomeWifi Instanz kopieren</label>
                                              </div>
                                          </div>
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LAT:</b></h5>
                                                  <input id="homeWifiLat10" name="homeWifiLat10" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value=""><i data-field="homeWifiLat10" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                              <div class="col fl fv-plugins-icon-container" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeWIFI<br><b>Koordinate LNG:</b></h5>
                                                  <input id="homeWifiLng10" name="homeWifiLng10" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value=""><i data-field="homeWifiLng10" class="fv-plugins-icon"></i>
                                              <div class="fv-plugins-message-container"></div></div>
                                          </div>
                                          <div class="row" style="padding-bottom: 4px;font-size: .8rem;">
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <!-- input type="button" class="addNewHomeWifiInstance"value="HomeWifi hinzufügen" -->
                                              </div>
                                              <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                                  <input type="button" class="removeHomeWifiInstance" value="HomeWifi entfernen"></input>
                                              </div>
                                              
                                          </div>
                                      </div>

                                      <div class="" id="" style="background:rgba(0,0,0,.05);padding-top:10px;">
                                          <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="col" style="margin-bottom: 4px;font-size: .8rem;">
                                              <div class="row">
                                                  <?php if($perm_button_homeWifiUpdate): ?><div class="col" style="margin-bottom: 4px;font-size: .8rem;"><button id="homeWifiUpdate" class="btn btn-primary" type="button" style="width: 100%;height:100%;">HomeWifi Daten Update</button></div><?php endif; ?>
                                                  <?php if($perm_button_homeWifiDelete): ?><div class="col"><button id="deleteHomeWifi" class="btn btn-primary" type="button" style="width: 100%;background: var(--bs-orange);">Alle HomeWifi Daten löschen</button></div><?php endif; ?>
                                              </div>  
                                              </div>
                                          </div>
                                      </div>
                                    
                                    
                                                                            
                                    </div>

                                    <!--
                                    <br>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeBeacon<br><b>BLE MAC-Adresse:</b><input id="homeBeaconMac" name="homeBeaconMac" data-fv-regexp="true" data-fv-treshold="16" data-fv-regexp___regexp="^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige MAC-Adresse an." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="aa:bb:cc:dd:ee" value=""></h5>
                                        </div>
                                        <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeBeacon<br><b>Beschreibung des Orts:</b></h5><input id="homeBeaconDescr" name="homeBeaconDescr" data-fv-string-length="true" data-fv-string-length___min="1" data-fv-string-length___max="16" data-fv-string-length___message="Beschreibung muss zwischen 1 und 16 Zeichen lang sein." type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="zu Hause" value="" maxlength="16">
                                        </div>
                                    </div>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeBeacon<br><b>Koordinate LAT:</b></h5><input id="homeBeaconLat" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." name="homeBeaconLat" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value="">
                                        </div>
                                        <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">HomeBeacon<br><b>Koordinate LNG:</b></h5><input id="homeBeaconLng" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-9]{1,2}|1[0-7][0-9]|180)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." name="homeBeaconLng" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value="">
                                        </div>
                                    </div>
                                    -->

                                    
                                    <br>
                                    <div class="row" style="margin-bottom: 4px;font-size: .8rem;">
                                        <div class="col" style="margin-bottom: 4px;font-size: .8rem;"><button id="saveButton" class="btn btn-primary" type="button" style="width: 100%;height:100%;">Nur Konfiguration speichern</button></div>
                                        <div class="col"><button id="saveSubmitButton" class="btn btn-primary" type="button" style="width: 100%;background: var(--bs-green);">Konfiguration speichern, übertragen &amp; SIM aktivieren</button></div>
                                    </div>
                                    <br>
                                    
                                    <div class="row baseStation" style="font-size: .8rem;background:rgba(0,0,0,.05);padding-top:1em;padding-bottom:1em;">
                                        <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">Basisstation<br><b>Koordinate LAT:</b></h5><input id="baseStationLat" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-8]?[0-9]|90)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." name="baseStationLat" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="48.0123" value="">
                                        </div>
                                        <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;">Basisstation<br><b>Koordinate LNG:</b></h5><input id="baseStationLng" data-fv-regexp="true" data-fv-treshold="2" data-fv-regexp___regexp="^-?([0-9]{1,2}|1[0-7][0-9]|180)(\.[0-9]{1,10})?$" data-fv-regexp___message="Bitte geben Sie eine valide, vollständige GPS-Koordinate an." name="baseStationLng" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;" placeholder="16.0321" value="">
                                        </div>
                                    </div>
                                    <div class="row baseStation" style="margin-bottom: 4px;font-size: .8rem;background:rgba(0,0,0,.05);padding-top:1em;padding-bottom:1em;">

                                        <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                        <br>
                                            <button id="baseStationTransmit" class="btn btn-primary" type="button" style="width: 100%;background: var(--bs-blue);">Basisstation jetzt verbinden</button>
                                        </div><br>
                                        <div class="col fl" style="margin-bottom: 4px;font-size: .8rem;">
                                            <h5 style="margin-bottom: 4px;font-size: .8rem;width: 100%;"><b>Status Verknüpfung:</b></h5><textarea id="baseStationActionState" name="baseStationActionState" type="text" style="width: 100%;border-radius: 3px;border-width: 1px;height:12em; font-size:1rem; padding:0.5em;" placeholder="" value="-" readonly="readonly"></textarea>
                                        </div>

                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col"><button id="enableSIM" class="btn btn-primary" type="button" style="width: 100%;background: var(--bs-green);">SIM aktivieren</button></div>
                                        <div class="col"><button id="disableSIM" class="btn btn-primary" type="button" style="width: 100%;height:100%;background: var(--bs-orange);">SIM deaktivieren</button></div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col"><button id="shutdownDevice" class="btn btn-primary" type="button" style="width: 100%;background: var(--bs-black);">Gerät ausschalten</button></div>
                                        <div class="col"><button id="returnDevice" class="btn btn-primary" type="button" style="width: 100%;height:100%;background: var(--bs-red);">Vom Kunden retour</button></div>
                                    </div>


                                    <div></div>
                                  </form>
                                </div>
                                <div class="col" style="height: auto;">
                                  <div class="row">
                                    
                                      <div clas="col">
                                              <?php generateDropdownHTML($data, $orgId) ?>
                                          </div>
                                          <br><br>
                                  </div>
                                        <ul class="nav nav-tabs" role="tablist">
                                            <li class="nav-item" role="presentation"><a id="tabOneLabel" class="nav-link active" role="tab" data-bs-toggle="tab" href="#tab-1" style="font-size: .7rem;">Bereit zum Aufbau</a></li>
                                            <li class="nav-item" role="presentation" style="font-size: .7rem;"><a id="tabTwoLabel" class="nav-link" role="tab" data-bs-toggle="tab" href="#tab-2" style="font-size: .7rem;">Angeschlossen</a></li>
                                        </ul>
                                        <div class="tab-content" style="max-height: 50vh;overflow: scroll;">
                                            <div class="tab-pane active" role="tabpanel" id="tab-1">
                                                <div class="table-responsive fs-6">
                                                    <table class="table">
                                                        <thead>
                                                            <tr>
                                                                <th style="font-size: .7rem;">IMEI</th>
                                                                <th style="font-size: .7rem;">MSISDN</th>
                                                                <th style="font-size: .7rem;">UMO Geräte-ID</th>
                                                                <th style="font-size: .7rem;">TYP</th>
                                                                <th style="font-size: .7rem;">ORG</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="deviceTable" style="font-size: .7rem;">
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <div class="tab-pane" role="tabpanel" id="tab-2">
                                                <div class="table-responsive fs-6">
                                                    <table class="table">
                                                        <thead>
                                                            <tr>
                                                                <th style="font-size: .7rem;">IMEI</th>
                                                                <th style="font-size: .7rem;">MSISDN</th>
                                                                <th style="font-size: .7rem;">UMO Geräte-ID</th>
                                                                <th style="font-size: .7rem;">TYP</th>
                                                                <th style="font-size: .7rem;">ORG</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="deviceTableUnassigned" style="font-size: .7rem;">
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="taskTableContainer"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="bg-white sticky-footer">
                <div class="container my-auto">
                    <div class="text-center my-auto copyright"><span>Copyright © Solution4Care - developed by KLOSS.PK</span></div>
                </div>
            </footer>
            </div>
        </div>
    </div>
    <script src="bs_assets/bootstrap/js/bootstrap.min.js"></script>
    <script src="bs_assets/js/bs-init.js"></script>
    <script src="bs_assets/js/theme.js"></script>
    <script src="onscan.min.js"></script>
    <script src="notify.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/es6-shim/0.35.3/es6-shim.min.js"></script>
    <script src="assets/js/formvalidation/js/FormValidation.min.js"></script>
    <script src="assets/js/formvalidation/js/plugins/Tachyons.min.js"></script>
    <script>
      var fv;
      var instanceCounter = 1;
      var orgId = "all";
    $(document).ready(function() {

      var selectedDropDownSubOrg = false;

      fv = FormValidation.formValidation(document.getElementById('assignmentForm'), {
        plugins: {
          declarative: new FormValidation.plugins.Declarative({ html5Input: true }),
          trigger: new FormValidation.plugins.Trigger({
                                event: "blur change keyup",
                                //threshold: 1,
                                //delay: 0,
                            })
          ,
          tachyons: new FormValidation.plugins.Tachyons(),
          //submitButton: new FormValidation.plugins.SubmitButton(),
          icon: new FormValidation.plugins.Icon({
            valid: 'fa fa-check',
            invalid: 'fa fa-times',
            validating: 'fa fa-refresh',
          })
        },
      });

    $.notify.defaults({ className: "success", hideDuration: 10000, style: 'bootstrap' });
    $(".baseStation").hide();

    function base64Encode(str) {
  let base64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  let result = '';
  let padding = '';
  let i;

  // Add padding if necessary
  if (str.length % 3) {
    padding = '=='.slice(0, 3 - str.length % 3);
    str += padding;
  }

  // Convert each 3 characters to base64
  for (i = 0; i < str.length; i += 3) {
    let triplet = (str.charCodeAt(i) << 16) + (str.charCodeAt(i + 1) << 8) + str.charCodeAt(i + 2);
    result += base64.charAt((triplet >> 18) & 0x3F) + base64.charAt((triplet >> 12) & 0x3F) + base64.charAt((triplet >> 6) & 0x3F) + base64.charAt(triplet & 0x3F);
  }

  // Replace padding with '='
  return result.slice(0, result.length - padding.length) + padding;
}

function loadImei(imei) {
      $.get("orgAdminZuw31sung4pi.php?imei="+imei+"&action=load", function(data, status){
        //console.log("Data: " + data + "\nStatus: " + status);

        $('.homeWifiInstancesContainer .homeWifiInstance:not(:first)').hide();
        //console.log("Data: " + data + "\nStatus: " + status);

        $("input:not([class='addNewHomeWifiInstance']):not([class='removeHomeWifiInstance'])").val("");
        $("#baseStationActionState").html("");
        $('#baseStationActionState').css("color", "black");
        $('#baseStationActionState').css("background-color", "white");
        fv.resetForm(true);

        if (typeof JSON.parse(data).data !== 'undefined') {
          $.notify("GELADEN: IMEI "+imei);
          data = JSON.parse(data).data;
          //console.log("data", data[0]);

          currentImei = data[0].imei;
          if (data[0].hardwareDeviceType !== "EV04" && data[0].hardwareDeviceType !== "EV07") {
            $(".baseStation").hide();
          } else {
            $(".baseStation").show();
          }
          $("#imeiInput").val(data[0].imei);
          $("#umoDeviceId").val(data[0].umoDeviceId);
          $("#umoDeviceIdInput").val(data[0].umoDeviceId);
          $("#hardwareDeviceTypeInput").val(data[0].hardwareDeviceType);
          if (data[0].active == 1) { $("#deviceStatusInput").val("Bereit zum Aufbau"); }
          else if (data[0].active == 2) { $("#deviceStatusInput").val("Angeschlossen"); }
          else { $("#deviceStatusInput").val(data[0].active); }
 
          if (data[0].simStatus == 1) { $("#simStatusInput").val("Bereit zur Aktivierung"); }
          else if (data[0].simStatus == 2) { $("#simStatusInput").val("Aktiv"); }
          else if (data[0].simStatus == 4) { $("#simStatusInput").val("Bereit zur Aktivierung"); }
          else if (data[0].simStatus == "-1") { $("#simStatusInput").val("Bereit zur Aktivierung"); }
          else { $("#simStatusInput").val("Unbekannt: '"+data[0].simStatus+"'"); }


          if (data[0].simOnlineStatus == 1) { $("#simOnlineStatusInput").val("Online"); }
          else if (data[0].simOnlineStatus == 0) { $("#simOnlineStatusInput").val("Offline"); }
          else { $("#simOnlineStatusInput").val("Unbekannt: '"+data[0].simOnlineStatus+"'"); }

          highestVisibleInstance = 1;
          console.log("instanceCounter before loop = "+instanceCounter);

          for (let i = 1; i <= 10; i++) {
            let mac = data[0][`homeWifiMac${i}`];
            let lat = data[0][`homeWifiLat${i}`];
            let lng = data[0][`homeWifiLng${i}`];
            let descr = data[0][`homeWifiDescr${i}`];

            $(`#homeWifiMac${i}`).val(mac);
            $(`#homeWifiLat${i}`).val(lat);
            $(`#homeWifiLng${i}`).val(lng);
            $(`#homeWifiDescr${i}`).val(descr);

            // If any of the fields are filled (i.e., not empty, null, or undefined), unhide the corresponding homeWifiInstance div
            if (mac || lat || lng || descr) {
              instanceCounter = i;
              highestVisibleInstance = i;
              console.log("hightestVisibleInstance ==="+highestVisibleInstance);
              $(`#homeWifiMac${i}`).closest('.homeWifiInstance').show(); // You can use .css('display', 'block') instead of .show() if you prefer
            }
          }

          console.log("instanceCounter after loop = "+instanceCounter);


          $("#homeBeaconMac").val(data[0].homeBeaconMac);
          $("#homeBeaconLat").val(data[0].homeBeaconLat);
          $("#homeBeaconLng").val(data[0].homeBeaconLng);
          $("#homeBeaconDescr").val(data[0].homeBeaconDescr);

          $("#baseStationLat").val(data[0].baseStationLat);
          $("#baseStationLng").val(data[0].baseStationLng);

          if (data[0].active == "2") {
            $("#deviceStatus").prop( "checked", true );
          } else {
            $("#deviceStatus").prop( "checked", false );
          }
          $("#msisdnInput").val(data[0].msisdn);
        } else {
          $.notify("FEHLER beim Laden von "+imei, "error");
          $("#imeiInput").val("");
          $("#baseStationActionState").html("");
          $("#baseStationActionState").html("");
        }
      });
    }

    function loadDeviceList() {

      

      var urlParam;
      if (orgId !== "all") {
        urlParam = orgId;

      } else {
        urlParam = "all";
      }
      console.log("setting urlParam = "+urlParam);
      $.get("orgAdmin4pi.php?action=loadEverything&orgId="+urlParam, function(data, status){

        $("#tabOneLabel").text("Bereit zum Aufbau (0)");
        $("#tabTwoLabel").text("Angeschlossen (0)");

        var tabOneCounter = 0;
        var tabTwoCounter = 0;

        //alert("Data: " + data + "\nStatus: " + status);
        data = JSON.parse(data).data;
        //console.log("data", data);

        

        $("#deviceTable").html("");
        $("#deviceTableUnassigned").html("");

        for(i=0;i<data.length;i++) {
          if (data[i].active === "1"){
            tabOneCounter++;
            //console.log("active === 1");
            //console.log("trying to append: "+'<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
            $("#deviceTable").append('<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+' <a target="_blank" href="kundenOrtung.php?device='+base64Encode(data[i].imei)+'"><img style="width:15px;height:15px;" src="./bs_assets/img/map.png" /></a></td> <td>'+data[i].msisdn+'</td> <td>'+data[i].umoDeviceId+'</td> <td>'+data[i].hardwareDeviceType+'</td> <td>'+data[i].orgName+'</td> </tr>');
          }
          else if (data[i].active === "2"){
            tabTwoCounter++;
            //console.log("active === 2");
            //console.log("trying to append: "+'<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
            $("#deviceTableUnassigned").append('<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+' <a target="_blank" href="kundenOrtung.php?device='+base64Encode(data[i].imei)+'"><img style="width:15px;height:15px;" src="./bs_assets/img/map.png" /></a></td> <td>'+data[i].msisdn+'</td> <td>'+data[i].umoDeviceId+'</td> <td>'+data[i].hardwareDeviceType+'</td> <td>'+data[i].orgName+'</td> </tr>');
          } else {
            //console.log("NO, active === "+data[i].active);
          }
        }
         
        $("#tabOneLabel").text("Bereit zum Aufbau ("+ tabOneCounter +")");
        $("#tabTwoLabel").text("Angeschlossen ("+ tabTwoCounter +")");

      });
    }

    function trackBaseStationTaskId(taskId) {
      if (typeof taskId !== 'undefined') {
        $.get("orgAdminZuw31sung4pi.php?action=baseStationTransmitStatus&taskId="+taskId, function(data, status){
        //alert("Data: " + data + "\nStatus: " + status);
        data = JSON.parse(data);
        //console.log("data", data);

        if (data.status === "done" && data.hardwareDeviceType === "EV07"){
            $("#baseStationActionState").html('Drücken Sie nun innerhalb von 2min an der Ladestation die "Call2" Taste bis Sie die Sprachdurchsage "Paarung erfolgreich" hören! Sobald die Ladestation blau leuchtet sind die Koordinaten programmiert.');
            $('#baseStationActionState').css("color", "white");
            $('#baseStationActionState').css("background-color", "green");
            setTimeout(function () {
              $("#baseStationActionState").html("");
              $('#baseStationActionState').css("color", "black");
              $('#baseStationActionState').css("background-color", "white");
            }, 120000);
          } else if (data.status === "done" && data.hardwareDeviceType !== "EV07"){
            $("#baseStationActionState").html("ERFOLGREICH VERSENDET!");
            $('#baseStationActionState').css("color", "white");
            $('#baseStationActionState').css("background-color", "green");
            setTimeout(function () {
              $("#baseStationActionState").html("");
              $('#baseStationActionState').css("color", "black");
              $('#baseStationActionState').css("background-color", "white");
            }, 120000);
          } else if (data.status === "undone"){
            $('#baseStationActionState').css("color", "black");
            $('#baseStationActionState').css("background-color", "orange");
            $("#baseStationActionState").html("SMS ist unterwegs!");
            setTimeout(function () {
              trackBaseStationTaskId(taskId);
            }, 1000);
          } else if (data.status === "error"){
            $('#baseStationActionState').css("color", "white");
            $('#baseStationActionState').css("background-color", "red");
            $("#baseStationActionState").html("Fehler SMS Versand!");
            setTimeout(function () {
              $("#baseStationActionState").html("");
              $('#baseStationActionState').css("color", "black");
              $('#baseStationActionState').css("background-color", "white");
            }, 120000);
          } else {
            console.log("unknown: ",data);
            //console.log("NO, active === "+data[i].active);
          }
      });
      }
    }


    var currentImei = "";
    var imeiInput = document.getElementById("imeiScanInput");
    onScan.attachTo(imeiInput, {
    suffixKeyCodes: [13], // enter-key expected at the end of a scan
    avgTimeByChar: 500,
    timeBeforeScanTest: 500,
    reactToPaste: true,
    reactToKeydown: true, // Compatibility to built-in scanners in paste-mode (as opposed to keyboard-mode)
    onScan: function(sCode, iQty) { // Alternative to document.addEventListener('scan')
      //console.log("WE DID SCAN: "+sCode);
      loadImei(sCode);
    }
    });

$('button:not(.dropdown-toggle)').on('click', function() {
    var button = $(this);
    // Disable the button
    button.prop('disabled', true);

    // Run your function here

    // Re-enable the button after 1 second
    setTimeout(function() {
        button.prop('disabled', false);
    }, 1000);
});

    $( "#saveButton" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "orgAdminZuw31sung4pi.php?imei="+currentImei+"&orgId=<?=$orgId?>&action=saveData", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: Daten für IMEI "+currentImei+" gespeichert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER beim Speichern von IMEI "+currentImei, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#saveSubmitButton" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "orgAdminZuw31sung4pi.php?imei="+currentImei+"&orgId=<?=$orgId?>&action=saveSubmit", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: Daten für IMEI "+currentImei+" gespeichert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER beim Speichern von IMEI "+currentImei, "error");
          console.log(decodedData);
        }
        if (decodedData.simUpdateStatus === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" konfiguriert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#homeWifiUpdate" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "orgAdminZuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=homeWifiUpdate", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: HomeWifi Update für IMEI "+currentImei+"!");
          loadDeviceList();
        } else {
          $.notify("FEHLER: HomeWifi Update für IMEI "+currentImei+"!");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#baseStationTransmit" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "orgAdminZuw31sung4pi.php?imei="+currentImei+"&orgId=<?=$orgId?>&action=baseStationTransmit", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG:  "+currentImei+" gespeichert!");
          loadDeviceList();
          trackBaseStationTaskId(decodedData.taskId);
        } else {
          $.notify("FEHLER BaseStationTransmit von IMEI "+currentImei+": "+decodedData.error, "error");
          console.log(decodedData.error);
        }
        /*
        if (decodedData.simUpdateStatus === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" konfiguriert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
        */
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#enableSIM" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "orgAdminZuw31sung4pi.php?imei="+currentImei+"&orgId=<?=$orgId?>&action=enableSIM", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" aktiviert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#disableSIM" ).on( "click", function() {
      if (currentImei !== "") {
      $.post( "orgAdminZuw31sung4pi.php?imei="+currentImei+"&orgId=<?=$orgId?>&action=disableSIM", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: SIM "+decodedData.msisdn+" deaktiviert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei SIM Änderung #"+decodedData.msisdn+decodedData.simUpdateError, "error");
          console.log(decodedData);
        }
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#returnDevice" ).on( "click", function() {
      $('#returnModal').modal('show');
    });

    $( "#deleteHomeWifi" ).on( "click", function() {
      $('#deleteHomeWifiModal').modal('show');
    });

    $( ".closeReturnModal" ).on( "click", function() {

      $("#returnModal").modal("hide");

    });

    $( ".closeDeleteHomeWifiModal" ).on( "click", function() {

$("#deleteHomeWifiModal").modal("hide");

    });

    $( ".closeShutdownModal" ).on( "click", function() {

      $("#shutdownModal").modal("hide");

    });

    $( "#confirmReturnModal" ).on( "click", function() {
      if (currentImei !== "") {
        if ($('#simOnlineStatusInput').val() != 1 && $('#simOnlineStatusInput').val() != "Online") {
          $("#returnModal").modal("hide");
          $.notify("FEHLER: Gerät NICHT ONLINE - bitte neu laden!", "error");
          return false;
        }
      $.post( "orgAdminZuw31sung4pi.php?imei="+currentImei+"&orgId=<?=$orgId?>&action=returnDevice", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: IMEI "+currentImei+" retourniert!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei Geräte-Retournierung IMEI "+currentImei, "error");
          console.log(decodedData);
        }
        $("#returnModal").modal("hide");
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

    $( "#confirmDeleteHomeWifiModal" ).on( "click", function() {
      if (currentImei !== "") {
        /*
        if ($('#simOnlineStatusInput').val() != 1 && $('#simOnlineStatusInput').val() != "Online") {
          $("#returnModal").modal("hide");
          $.notify("FEHLER: Gerät NICHT ONLINE - bitte neu laden!", "error");
          return false;
        }
        */
      $.post( "orgAdminZuw31sung4pi.php?token=f48r7z4f784348fu33ß9e2r2&imei="+currentImei+"&orgId=<?=$orgId?>&action=deleteHomeWifi", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: Home Wifi gelöscht für IMEI "+currentImei+"!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei Home Wifi löschen für IMEI "+currentImei, "error");
          console.log(decodedData);
        }
        $("#deleteHomeWifiModal").modal("hide");
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });

$( "#confirmShutdownModal" ).on( "click", function() {

  if (currentImei !== "") {
      $.post( "orgAdminZuw31sung4pi.php?imei="+currentImei+"&orgId=<?=$orgId?>&action=shutdownDevice", $( "#assignmentForm" ).serialize() ).done(function(response){
        var decodedData = JSON.parse(response);
        console.log("decodedData = ", decodedData);
        if (decodedData.status === "done") {
          $.notify("ERFOLG: Shutdown-Command an IMEI "+currentImei+" eingeplant!");
          loadDeviceList();
        } else {
          $.notify("FEHLER bei Geräte-Shutdown IMEI", "error");
          console.log(decodedData);
        }
        $("#shutdownModal").modal("hide");
      });
      setTimeout(function () {
        loadImei(currentImei);
      }, 1000);
      //$.notify("ERFOLG: IMEI "+currentImei);
    } else {
      $.notify("FEHLER: Zuerst Gerät scannen / laden !", "error");
    }

    });



    $( "#shutdownDevice" ).on( "click", function() {

      $('#shutdownModal').modal('show');

    });

       // Initialize an empty object to store multiple timeouts
var homeWifiLatLngTimeOuts = {};

// Define regular expression for lat,lng pattern
var regex = /^(\-?\d+(\.\d+)?),\s*(\-?\d+(\.\d+)?)$/;

for (let i = 1; i <= 10; i++) {
    let latID = '#homeWifiLat' + i;
    let lngID = '#homeWifiLng' + i;
    let macID = '#homeWifiMac' + i;
    let selector = latID + ', ' + lngID;

    $(selector).on('keyup blur change focus', function () {
        // Store the context of the input that triggered the event
        let inputContext = this;

        clearTimeout(window['homeWifiLatLngTimeOut' + i]);

        window['homeWifiLatLngTimeOut' + i] = setTimeout(function () {
            var match = $(inputContext).val().match(regex);
            if (match) {
                // If match, split and assign to inputs
                var [lat, lng] = match[0].split(',');

                // Round lat and lng to up to 6 decimal places
                lat = Number(lat).toFixed(10);
                lng = Number(lng).toFixed(10);

                $(latID).val(lat);
                $(lngID).val(lng);

                $(macID).focus();
                $(inputContext).focus();

                // Call the function
                reportValidcoordinateValidation();
            }
        }, 500); // Delay in milliseconds
    });
}





// Don't forget to implement or declare reportValidcoordinateValidation() somewhere in your code
function reportValidcoordinateValidation() {
  // Implement your function here
}


    $(".homeWifiMac, #homeBeaconMac").on("keyup blur change", function(event) {

      var limitField = $(this).val().trim().length;
      var limit = "17";

      if (event.keyCode != 8) {
        var mac_value = $(this).val().trim().concat(':');
        switch(limitField) {
          case 2:
          case 5:
          case 8:
          case 11:
          case 14:
            $(this).val(mac_value);
            break;
        }
      }

      if (limitField > limit) {
        $("#mac").val($(this).val().trim().substring(0, limit));
      }
    });

    $("#mandantenDropdown > a").click(function(){
          var clickedId = $(this).attr("data-orgId");
          var clickedName = $(this).html();

          orgId = clickedId;

          $("#tabOneLabel").text("Bereit zum Aufbau (Lade...)");
          $("#tabTwoLabel").text("Angeschlossen (Lade...)");

          console.log("orgId changed to "+orgId);
          $.get("orgAdmin4pi.php?action=loadEverything&orgId="+clickedId, function(data, status){
            //alert("Data: " + data + "\nStatus: " + status);
            data = JSON.parse(data).data;
            console.log("data", data);
            $("#deviceTable").html("");
            $("#deviceTableUnassigned").html("");

            for(i=0;i<data.length;i++) {
              if (data[i].active == "1"){
                //console.log("active === 1");
                //console.log("trying to append: "+'<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
                $("#deviceTable").append('<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+' <a target="_blank" href="kundenOrtung.php?device='+base64Encode(data[i].imei)+'"><img style="width:15px;height:15px;" src="./bs_assets/img/map.png" /></a></td> <td>'+data[i].msisdn+'</td> <td>'+data[i].umoDeviceId+'</td> <td>'+data[i].hardwareDeviceType+'</td> <td>'+data[i].orgName+'</td> </tr>');
              }
              else if (data[i].active == "2"){
                //console.log("active === 2");
                //console.log("trying to append: "+'<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+'</td> <td>'+data[i].msisdn+'</td> <td>'+data[i].hardwareDeviceType+'</td> </tr>');
                $("#deviceTableUnassigned").append('<tr><td style="color: rgb(133, 135, 150);">'+data[i].imei+' <a target="_blank" href="kundenOrtung.php?device='+base64Encode(data[i].imei)+'"><img style="width:15px;height:15px;" src="./bs_assets/img/map.png" /></a></td> <td>'+data[i].msisdn+'</td> <td>'+data[i].umoDeviceId+'</td> <td>'+data[i].hardwareDeviceType+'</td> <td>'+data[i].orgName+'</td> </tr>');
              } else {
                //console.log("NO, active === "+data[i].active);
              }
            }
          });
          $("#mandantenButton").html(clickedName);
    });

    loadDeviceList();

    setInterval(function () {

      loadDeviceList();

    }, 10000);

  });

    </script>

    <script>

       let maxHomeWifiInstances = 10; // Maximum number of homeWifiInstances
        let highestVisibleInstance = 1;

       $(document).ready(function() {
        

        // Function to add new homeWifiInstance
        $('.homeWifiInstancesContainer').on('click', '.addNewHomeWifiInstance', function() {
          console.log("Add button clicked in: ", $(this).closest('.homeWifiInstance').attr('id'));

          for (let i = 1; i <= maxHomeWifiInstances; i++) {
            if ($('#homeWifiInstance' + i).is(':hidden')) {
              $('#homeWifiInstance' + i).show();
              highestVisibleInstance = i;
              console.log("after ADD HWIFI highestVisibleInstance = "+i);
              break;
            }
          }
        });

                // Function to remove homeWifiInstance
        $('.homeWifiInstancesContainer').on('click', '.removeHomeWifiInstance', function() {
          console.log("Remove button clicked in: ", $(this).closest('.homeWifiInstance').attr('id'));

          let instanceDiv = $(this).closest('.homeWifiInstance');
          let idToRemove = parseInt(instanceDiv.attr('id').replace('homeWifiInstance', ''));

          if (idToRemove === 1 && highestVisibleInstance === 1) {
            // If it's the first and only visible instance, clear it
            instanceDiv.find('input[type="text"]').val('');
            instanceDiv.find('input[type="checkbox"]').prop('checked', false);
            return;
          }

          // Shift down higher instances to fill the gap
          for (let i = idToRemove; i < highestVisibleInstance; i++) {
            let currentDiv = $('#homeWifiInstance' + i);
            let nextDiv = $('#homeWifiInstance' + (i + 1));

            // Shift data from nextDiv to currentDiv
            let valuesToMove = {
              homeWifiMac: $('#homeWifiMac' + (i + 1)).val(),
              homeWifiDescr: $('#homeWifiDescr' + (i + 1)).val(),
              homeWifiLat: $('#homeWifiLat' + (i + 1)).val(),
              homeWifiLng: $('#homeWifiLng' + (i + 1)).val(),
              copyCoordinates: $('#copyCoordinates' + (i + 1)).prop('checked')
            };

            $('#homeWifiMac' + i).val(valuesToMove.homeWifiMac);
            $('#homeWifiDescr' + i).val(valuesToMove.homeWifiDescr);
            $('#homeWifiLat' + i).val(valuesToMove.homeWifiLat);
            $('#homeWifiLng' + i).val(valuesToMove.homeWifiLng);
            $('#copyCoordinates' + i).prop('checked', valuesToMove.copyCoordinates);

            // Make sure the currentDiv is visible
            currentDiv.show();
          }

          // Hide and clear the last shifted-down instance
          let lastInstance = $('#homeWifiInstance' + highestVisibleInstance);
          lastInstance.hide();
          lastInstance.find('input[type="text"]').val('');
          lastInstance.find('input[type="checkbox"]').prop('checked', false);

          highestVisibleInstance--;
          console.log("after REMOVE HWIFI highestVisibleInstance = "+highestVisibleInstance);
        });


        // Function to update coordinates based on the first instance
    const updateCoordinates = function(instanceIndexToClear = null) {
        const firstInstanceLat = $('#homeWifiLat1').val();
        const firstInstanceLng = $('#homeWifiLng1').val();
        
        // Update instances where the checkbox is checked
        $('.copy-coordinates:checked').each(function() {
            const instanceIndex = $(this).attr('id').replace('copyCoordinates', '');
            if (instanceIndex !== '1') {
                $(`#homeWifiLat${instanceIndex}`).val(firstInstanceLat);
                $(`#homeWifiLng${instanceIndex}`).val(firstInstanceLng);
            }
        });
        
        // Clear coordinates only for the instance that had its checkbox unticked
        if (instanceIndexToClear !== null && instanceIndexToClear !== '1') {
            $(`#homeWifiLat${instanceIndexToClear}`).val("");
            $(`#homeWifiLng${instanceIndexToClear}`).val("");
        }
    };

    // Event Listener for "Copy Coordinates" checkbox
    $(document).on('change', '.copy-coordinates', function() {
        const instanceIndex = $(this).attr('id').replace('copyCoordinates', '');
        if ($(this).is(':checked')) {
            // If checked, update all the coordinates
            updateCoordinates();
        } else {
            // If unchecked, clear only for this instance
            updateCoordinates(instanceIndex);
        }
    });

    // Periodically listen for changes to #homeWifiLat1 and #homeWifiLng1
    $('#homeWifiLat1, #homeWifiLng1').on('input', function() {
        updateCoordinates();
    });

    

});

$(document).ready(function() {
    const fetchAndUpdateTasks = function() {
        $.ajax({
            url: 'zuw31sung4pi.php?action=loadTasks',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                let tableHtml = '<table style="width: 100%;"><thead class="sticky-header"><tr><th>ZEITSTEMPEL</th><th>IMEI</th><th>PROGRAMMIERSCHRITT</th><th style="display:none;">taskId</th><th>STATUS</th></tr></thead><tbody>';
                $.each(response.data.reverse(), function(index, task) {
                    let rowClass = '';
                    let statusTranslated = '';
                    let packageTypeTranslated = '';
                    console.log("lastModTS:"+task.lastModificationTimestamp);
                    //let tempDate = new Date(parseInt(task.lastModificationTimestamp) * 1000);
                    let timeString = new Date(task.lastModificationTimestamp * 1000).toLocaleString("de-AT");
                    //let timeString = tempDate.toLocaleString("de-AT", {timeZone: "Europe/Vienna"});

                    if (task.status === '2') {
                        rowClass = 'status-2';
                        statusTranslated = 'OK';
                    } else if (task.status === '3') {
                        rowClass = 'status-3';
                        statusTranslated = 'Fehler';
                    } else if (task.status === '1') {
                        rowClass =  'blink';
                        statusTranslated = 'In Bearbeitung';
                    }  else if (task.status === '0') {
                        statusTranslated = 'Warten auf Gerät';
                    }

                    if (task.packetType === 'updateHomeWifi') {
                      packageTypeTranslated = 'HomeWifi Update';
                    } else if (task.packetType === 'resetDevice') {
                      packageTypeTranslated = 'Werkseinstellungen';
                    } else if (task.packetType === 'resetDeviceSuccessfull') {
                      packageTypeTranslated = 'SIM deaktivieren';
                    }  else if (task.packetType === 'shutdownDevice') {
                      packageTypeTranslated = 'Herunterfahren';
                    } else if (task.packetType === 'continousLocateParameters') {
                      packageTypeTranslated = 'Konfiguration Ortungsintervall';
                    } else if (task.packetType === 'startContinousLocate') {
                      packageTypeTranslated = 'Echtzeitortung';
                    } else if (task.packetType === 'timeIntervalParameters') {
                      packageTypeTranslated = 'Konfiguration HB/GPS Intervall';
                    } else if (task.packetType === 'setWorkingMode') {
                      packageTypeTranslated = 'Konfiguration Gerätemodus';
                    } else if (task.packetType === 'setContactNumbers') {
                      packageTypeTranslated = 'Konfiguration Notrufnummern';
                    } else if (task.packetType === 'setContactNumbersPhoto') {
                      packageTypeTranslated = 'Konfiguration Notrufnummern';
                    } else if (task.packetType === 'multi_transmitConfig') {
                      packageTypeTranslated = 'Konfiguration speichern, übertragen & SIM aktivieren';
                    } else {
                      packageTypeTranslated = task.packetType;
                    }

                    tableHtml += `<tr class="${rowClass}"><td>${timeString}</td><td>${task.imei}</td><td>${packageTypeTranslated}</td><td style="display:none;">${task.taskId}</td><td>${statusTranslated}</td></tr>`;
                });
                tableHtml += '</tbody></table>';
                $('#taskTableContainer').html(tableHtml);

                // Blinking effect for status 2
                setInterval(() => {
                    $('.status-2').each(function() {
                        $(this).toggleClass('originalBgColor');
                    });
                }, 1000);
            },
            error: function(xhr, status, error) {
                console.error("Error fetching tasks:", error);
            }
        });
    };

    fetchAndUpdateTasks(); // Initial fetch
    setInterval(fetchAndUpdateTasks, 2500); // Update every 5 seconds
});


    </script>
</body>

</html>
