<?php

require('Medoo.php');
use \Medoo\Medoo;

function logDebug($input) {
  $filename = 'incomingSmsDebug.log';
  $datetime = date('Y-m-d H:i:s');
  $output = $datetime . ' ' . $input . "\n";
  file_put_contents($filename, $output, FILE_APPEND);
}

function convert_battery_level($value) {
    // ensure $value is between 1 and 10
    //$value = max(1, min(10, $value));

    // calculate the battery level scale
    //$battery_scale = round($value / 10 * 7) + 1;

    return $value;
}

function convertDateTimeToISO($dateTimeString) {
  $viennaTimeZone = new DateTimeZone('Europe/Vienna');
  $dateTime = new DateTime($dateTimeString, $viennaTimeZone);
  $utcTimeZone = new DateTimeZone('UTC');
  $dateTime->setTimezone($utcTimeZone);
  return $dateTime->format('Y-m-d\TH:i:s.u\Z');
}

function fix_url($url) {
  $url = trim($url);
  // Check if the URL is valid
  if (filter_var($url, FILTER_VALIDATE_URL) === false) {
    //return false;
    if (strpos($url, 'http://') === false && strpos($url, 'https://') === false) {
      $url = 'http://' . $url;
      if (filter_var($url, FILTER_VALIDATE_URL) !== false) {
          return $url;
        }
    }
  }

  // Check if the URL has http:// or https:// at the beginning
  echo "we will return $url<br>";
  return $url;
}

function getRedirectUrl ($url) {
  //echo "url to use for redirect: ".fix_url($url);
    stream_context_set_default(array(
        'http' => array(
            'method' => 'HEAD'
        )
    ));
    $headers = get_headers(fix_url($url), 1);
    echo "headers of $url ";
    print_r($headers);
    echo "<br>";
    if ($headers !== false && isset($headers['Location'])) {
        return $headers['Location'];
    }

    echo "no redirect URL found<br>";
    return false;
}

function extractDateTimeAndBatteryLevel($str) {
  $dateTime = null;
  $batteryLevel = null;

  // Match for dateTime in format: mm/dd/yyyy hh:mm:ss
  preg_match('/eit:(\d{2}\/\d{2}\/\d{4} \d{2}:\d{2}:\d{2})/', $str, $eitMatches);
  if (count($eitMatches) > 0) {
    $dateTime = $eitMatches[1];
    //$dateTime = str_replace("/","-",$dateTime);
    $dateTime = convertDateTimeToISO($dateTime,'Y-m-d H:i:s');
  }

  preg_match('/ime:(\d{2}\/\d{2}\/\d{4} \d{2}:\d{2}:\d{2})/', $str, $imeMatches);
  if (count($imeMatches) > 0) {
    $dateTime = $imeMatches[1];
    $month = substr($dateTime, 0, 2);
    $day = substr($dateTime, 3, 2);
    $year = substr($dateTime, 6, 4);
    $time = substr($dateTime, 11);
    $newDateTime = $day . '/' . $month . '/' . $year . ' ' . $time;
    $dateTime = convertDateTimeToISO($newDateTime,'Y-m-d H:i:s');
  }

  // Match for batteryLevel in format: 0-100%
  preg_match('/\d{1,3}%/', $str, $matches);
  if (count($matches) > 0) {
    $batteryLevel = $matches[0];
    $batteryLevel = str_replace("%","",$batteryLevel);
    //auskommentiert weil nicht notwendig:
    //$batteryLevel = round(intVal($batteryLevel) / 10);
    //$batteryLevel = convert_battery_level($batteryLevel);
  }

  return array('dateTime' => $dateTime, 'batteryLevel' => $batteryLevel);
}

function processLocationSms($string, $deviceArray, $database) {
  $pattern1 = '/\s*smart-locator\.com\/web\/geolocation\/(?:wg|lb2)\/[-A-Za-z0-9._~:\/?#@!$&\'()*+,;=%]+\s*/';
  // old pattern: $pattern1 = '/www\.smart-locator\.com\/web\/geolocation\/wg\/[A-Za-z0-9\-_]+={2,}/';
  $pattern2 = '/www\.google\.com\/maps\?q=-?[0-9.]+,-?[0-9.]+/';

  $pattern3 = '/Lage:(.*?)[\r\n]/';

  if (preg_match_all($pattern1, $string, $smartLocMatches)) {

    $finalRedirectUrl = getRedirectUrl($smartLocMatches[0][0]);
    //echo "finalRedirectURL: ".$finalRedirectUrl;
    $dateTimeBattery = extractDateTimeAndBatteryLevel($string);
    $latLng = extract_lat_lng_from_google_maps_uri($finalRedirectUrl);
    //echo "latLng: ";
    //print_r($latLng);
    print_r(array(
      "lat" => $latLng['lat'],
      "lng" => $latLng['lng'],
      "battery" => $dateTimeBattery['batteryLevel'],
      "dateTime" => $dateTimeBattery['dateTime']
    ));
    return array(
      "lat" => $latLng['lat'],
      "lng" => $latLng['lng'],
      "battery" => $dateTimeBattery['batteryLevel'],
      "dateTime" => $dateTimeBattery['dateTime']
    );
  }
  if (preg_match_all($pattern2, $string, $googleMapMatches)) {
    //echo "match2";
    print_r(extract_lat_lng_from_google_maps_uri($string));
    //echo "finalRedirectURL: ".$finalRedirectUrl;
    $dateTimeBattery = extractDateTimeAndBatteryLevel($string);
    print_r(array(
      "lat" => extract_lat_lng_from_google_maps_uri($string)['lat'],
      "lng" => extract_lat_lng_from_google_maps_uri($string)['lng'],
      "battery" => $dateTimeBattery['batteryLevel'],
      "dateTime" => $dateTimeBattery['dateTime']
    ));
    return array(
      "lat" => extract_lat_lng_from_google_maps_uri($string)['lat'],
      "lng" => extract_lat_lng_from_google_maps_uri($string)['lng'],
      "battery" => $dateTimeBattery['batteryLevel'],
      "dateTime" => $dateTimeBattery['dateTime']
    );
  }
  if (preg_match_all($pattern3, $string, $homeWifiMatches)) {

    $homeWifiName = $homeWifiMatches[1][0];

    if (trim($deviceArray['homeWifiDescr']) == trim($homeWifiName)) {
      $dateTimeBattery = extractDateTimeAndBatteryLevel($string);
      print_r(array(
        "lat" => $deviceArray['homeWifiLat'],
        "lng" => $deviceArray['homeWifiLng'],
        "battery" => $dateTimeBattery['batteryLevel'],
        "dateTime" => $dateTimeBattery['dateTime'],
        "description" => $homeWifiName
      ));
      return array(
        "lat" => $deviceArray['homeWifiLat'],
        "lng" => $deviceArray['homeWifiLng'],
        "battery" => $dateTimeBattery['batteryLevel'],
        "dateTime" => $dateTimeBattery['dateTime'],
        "description" => $homeWifiName
      );
    }

  }
  echo false;
  return false;
}

function extract_lat_lng_from_google_maps_uri($uri) {
  //echo "latLng: $uri";
  $lat_lng = array();

  // Extract the latitude and longitude from the URI
  preg_match('/q=(-?[0-9.]+),(-?[0-9.]+)/', $uri, $matches);

  // If the latitude and longitude are found, add them to the array
  if (count($matches) == 3) {
    $lat_lng['lat'] = $matches[1];
    $lat_lng['lng'] = $matches[2];
  }

  return $lat_lng;
}


if(isset($_GET['token']) AND $_GET['token'] === "20d59408f2e91da908d202aefdc2f248652b7331") {

  $database = new \Medoo\Medoo([
    // [required]
    'type' => 'mysql',
    'host' => 'localhost',
    'database' => 'gpsTest',
    'username' => 'gpsTest',
    'password' => '6HNV*=?U',

    // [optional]
    'charset' => 'utf8mb4',
    'collation' => 'utf8mb4_general_ci',
    'port' => 3306,

    // [optional] The table prefix. All table names will be prefixed as PREFIX_table.
  //	'prefix' => 'PREFIX_',

    // [optional] To enable logging. It is disabled by default for better performance.
    //'logging' => true,

    // [optional]
    // Error mode
    // Error handling strategies when the error has occurred.
    // PDO::ERRMODE_SILENT (default) | PDO::ERRMODE_WARNING | PDO::ERRMODE_EXCEPTION
    // Read more from https://www.php.net/manual/en/pdo.error-handling.php.
    'error' => PDO::ERRMODE_SILENT,

    // [optional]
    // The driver_option for connection.
    // Read more from http://www.php.net/manual/en/pdo.setattribute.php.

    'option' => [
      PDO::ATTR_CASE => PDO::CASE_NATURAL
    ],

    // [optional] Medoo will execute those commands after the database is connected.
    /*
    'command' => [
      'SET SQL_MODE=ANSI_QUOTES'
    ]
    */
  ]);

  $inputJSON = file_get_contents('php://input');
  $input = json_decode($inputJSON, TRUE);

  if (!isset($input["id"]) AND !isset($input["message"]) AND !isset($input["msisdn"])) {
    header("HTTP/1.1 401 Unauthorized");
    exit();
  }

  $data = $database->select("devices", "*",
  [ "msisdn" => $input["msisdn"] ]
  );

  if (count($data) === 1) {

    $processMessage = processLocationSms($input["message"],$data[0],$database);

    if ($processMessage !== false) {

      $insertSMS = $database->insert("locationData", [
        "imei" => $data[0]["imei"],
        "type" => "smsLoc",
        "lat" => $processMessage["lat"],
        "lng" => $processMessage["lng"],
        "time" => $processMessage["dateTime"],
        "description" => "",
        "generalData" => '{"batteryLevel":'.$processMessage["battery"].',"cellNetworkSignalStrength":"X","timeStamp":"'.$processMessage["dateTime"].'"}'
      ]);

      header("HTTP/1.1 200 OK");

      echo json_encode([
        "imei" => $data[0]["imei"],
        "type" => "smsLoc",
        "lat" => $processMessage["lat"],
        "lng" => $processMessage["lng"],
        "time" => $processMessage["dateTime"],
        "generalData" => '{"batteryLevel":'.$processMessage["battery"].',"cellNetworkSignalStrength":"X","timeStamp":"'.$processMessage["dateTime"].'"}'
      ]);
      exit();
    }
  } else {
    header("HTTP/1.1 404 Not Found");
    exit();
  }


      /*

  $data = $database->select("devices", "*",
  [ "organisationId" => $orgId ]
  );

  if (count($data) > 0) {

    $data[0]['simStatus'] = getSimStateFromICCID(getSimByMSISDN($data[0]['msisdn']));

    echo json_encode(array("data" => $data));
  } else {
    echo json_encode(array("error" => "devices not found"));
  }
  */

} else {
  header("HTTP/1.1 401 Unauthorized");
  exit();
}

?>
