<?php



date_default_timezone_set('Europe/Vienna');

$userId = $_SESSION['id'];

$changelogs = $database->select("changelog", "*");
$viewedChangelogs = $database->select("user_changelog_views", "changelog_id", ["user_id" => $userId]);

$unseenChangelogs = array_filter($changelogs, function($changelog) use ($viewedChangelogs) {
    return !in_array($changelog['id'], $viewedChangelogs);
});

$unseenIds = array_map(function($changelog) {
    return $changelog['id'];
}, $unseenChangelogs);
?>

<!-- Widget CSS -->
<style>
#changelogWidget {
    border: 1px solid #ccc;
    padding: 10px;
    position: fixed;
    bottom: 10px;
    right: 10px;
    background-color: #f9f9f9;
    width: 280px;
    overflow-y: auto;
}

.changelogEntry {
    border: 1px solid #ddd;
    padding: 10px;
    margin-top: 10px;
    background-color: #fff;
}

.changelogEntry:nth-child(odd) {
    background-color: #f4f4f4;
}

.changelogTitle {
    cursor: pointer;
    font-weight: bold;
    margin: 0;
    font-size: 1em;
}

.changelogDate {
    font-size: 0.85em;
    margin: 4px 0;
    color: #666;
}

.changelogDescription {
    display: none;
    margin-top: 8px;
    font-size: 0.8em;
}

#closeChangelog {
    background-color: #e74c3c;
    color: #fff;
    border: none;
    padding: 5px 15px;
    cursor: pointer;
    margin-top: 10px;
    display: block;
    width: 100%;
}
</style>

<!-- Widget HTML -->
<?php if (count($unseenChangelogs) > 0): ?>
<div id="changelogWidget">
    <?php foreach ($unseenChangelogs as $changelog):
    $date = new DateTime($changelog['date_added']);
    $date->setTimezone(new DateTimeZone('Europe/Vienna'));
    $formattedDate = $date->format('d.m.Y');
?>
    <div class="changelogEntry" data-id="<?php echo $changelog['id']; ?>">
        <p class="changelogDate"><?php echo $formattedDate; ?></p>
        <h4 class="changelogTitle"><?php echo $changelog['title']; ?></h4>
        <p class="changelogDescription"><?php echo $changelog['description']; ?></p>
    </div>
<?php endforeach; ?>
    <button id="closeChangelog">Alle Gelesen / Schließen</button>
</div>

<!-- Widget JS -->
<script>
$(document).ready(function() {
    $('.changelogTitle').on('click', function() {
        let description = $(this).nextAll('.changelogDescription').first();
        if (description.is(':visible')) {
            description.slideUp();
        } else {
            $('.changelogDescription').slideUp();
            description.slideDown();
        }
    });

    $('#closeChangelog').on('click', function() {
        const unseenIds = <?php echo json_encode($unseenIds); ?>;
        
        $.post('markAsViewed.php', { changelogIds: unseenIds }, function(response) {
            if (response.trim() === 'success') {
                $('#changelogWidget').remove();
            } else {
                alert('Error marking changelogs as viewed.');
            }
        });
    });
});
</script>

<?php endif; ?>
